/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Color;
import java.awt.Font;
import org.w3c.dom.Element;
import uk.ac.starlink.ast.grf.DefaultGrf;
import uk.ac.starlink.ast.grf.DefaultGrfFontManager;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;

public class AstTitle
extends AbstractPlotControlsModel {
    protected boolean isSet;
    protected boolean show;
    protected String title;
    protected Font font;
    protected Color colour;
    protected double gap;
    public static final double GAP_MIN = -0.5;
    public static final double GAP_MAX = 0.5;
    public static final double GAP_STEP = 0.005;
    public static final String NULL_TITLE = "Using default title";
    protected DefaultGrfFontManager grfFontManager = DefaultGrfFontManager.getReference();

    public AstTitle() {
        this.setDefaults();
    }

    public AstTitle(String title) {
        this.setDefaults();
        this.setTitle(title);
    }

    public void setDefaults() {
        this.isSet = false;
        this.show = true;
        this.title = NULL_TITLE;
        this.colour = Color.black;
        this.font = null;
        this.gap = 0.05;
        this.fireChanged();
    }

    public void setState(boolean isSet) {
        this.isSet = isSet;
        this.fireChanged();
    }

    public boolean getState() {
        return this.isSet;
    }

    public void setShown(boolean show) {
        this.show = show;
        this.setState(true);
        this.fireChanged();
    }

    public boolean getShown() {
        return this.show;
    }

    public void setTitle(String title) {
        this.title = title;
        if (title != null && !title.equals(NULL_TITLE)) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public String getTitle() {
        return this.title;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.setState(true);
            this.grfFontManager.add(font);
        }
        if (this.font != null) {
            this.grfFontManager.remove(this.font);
        }
        this.font = font;
        this.fireChanged();
    }

    public Font getFont() {
        return this.font;
    }

    public void setColour(Color colour) {
        this.colour = colour;
        if (colour != null) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public Color getColour() {
        return this.colour;
    }

    public void setGap(double gap) {
        this.gap = gap;
        if (gap != DefaultGrf.BAD) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public double getGap() {
        return this.gap;
    }

    public String getAstOptions() {
        if (!this.isSet) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (this.show) {
            buffer.append("DrawTitle=1");
            if (this.title != null && !this.title.equals("") && !this.title.equals(NULL_TITLE)) {
                buffer.append(",title=");
                buffer.append(this.title);
            }
            if (this.font != null) {
                buffer.append(",Font(Title)=");
                buffer.append(this.grfFontManager.getIndex(this.font));
            }
            if (this.colour != null) {
                buffer.append(",Colour(title)=");
                int value = DefaultGrf.encodeColor(this.colour);
                if (value == -1) {
                    value = 0;
                }
                buffer.append(value);
            }
            if (this.gap != DefaultGrf.BAD) {
                buffer.append(",TitleGap=");
                buffer.append(this.gap);
            }
        } else {
            buffer.append("DrawTitle=0");
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getAstOptions();
    }

    public String getTagName() {
        return "title";
    }

    public void encode(Element rootElement) {
        this.addChildElement(rootElement, "isSet", this.isSet);
        this.addChildElement(rootElement, "show", this.show);
        this.addChildElement(rootElement, "title", this.title);
        if (this.font != null) {
            this.addChildElement(rootElement, "font", this.font);
        }
        if (this.colour != null) {
            this.addChildElement(rootElement, "colour", this.colour);
        }
        this.addChildElement(rootElement, "gap", this.gap);
    }

    public void setFromString(String name, String value) {
        if (name.equals("isSet")) {
            this.setState(this.booleanFromString(value));
            return;
        }
        if (name.equals("show")) {
            this.setShown(this.booleanFromString(value));
            return;
        }
        if (name.equals("title")) {
            this.setTitle(value);
            return;
        }
        if (name.equals("font")) {
            this.setFont(this.fontFromString(value));
            return;
        }
        if (name.equals("colour")) {
            this.setColour(this.colorFromString(value));
            return;
        }
        if (name.equals("gap")) {
            this.setGap(this.doubleFromString(value));
            return;
        }
        System.err.println("AstTitle: unknown configuration property:" + name + " (" + value + ")");
    }
}

