/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;
import uk.ac.starlink.ast.gui.ColourIcon;
import uk.ac.starlink.ast.gui.ColourStore;
import uk.ac.starlink.ast.gui.PlotController;
import uk.ac.starlink.ast.gui.PlotControls;
import uk.ac.starlink.ast.gui.Utilities;
import uk.ac.starlink.util.gui.GridBagLayouter;

public class ComponentColourControls
extends JPanel
implements PlotControls,
ChangeListener {
    protected PlotController controller = null;
    protected ColourIcon colourIcon = new ColourIcon(Color.black);
    protected JButton colourButton = new JButton();
    protected JLabel colourLabel = new JLabel();
    protected String description = null;
    protected String title = "Colour controls:";
    protected String name = "Colour";
    protected ColourStore colourStore = null;
    protected Color originalColour = Color.black;
    static /* synthetic */ Class class$uk$ac$starlink$ast$gui$ColourStore;

    public ComponentColourControls(PlotController controller, AbstractPlotControlsModel colourStore, String title, String name, String label) throws RuntimeException {
        this.initUI();
        this.setController(controller);
        this.setColourStore((ColourStore)colourStore);
        this.setDescription(title, name, label);
    }

    protected void initUI() {
        this.colourButton.setIcon(this.colourIcon);
        this.colourButton.setToolTipText("Press to select a new colour");
        this.colourButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComponentColourControls.this.chooseColour();
            }
        });
        GridBagLayouter layouter = Utilities.getGridBagLayouter(this);
        layouter.add((Component)this.colourLabel, false);
        layouter.add((Component)this.colourButton, false);
        layouter.eatLine();
        layouter.eatSpare();
    }

    public void setController(PlotController controller) {
        this.controller = controller;
        this.originalColour = controller.getPlotColour();
    }

    public void setColourStore(ColourStore colourStore) {
        this.colourStore = colourStore;
        colourStore.addChangeListener(this);
    }

    public ColourStore getColourStore() {
        return this.colourStore;
    }

    public PlotController getPlotController() {
        return this.controller;
    }

    public void setDescription(String title, String name, String label) {
        this.description = label;
        this.title = title;
        this.name = name;
        this.colourLabel.setText(label);
    }

    public String getDescription() {
        return this.description;
    }

    protected void chooseColour() {
        Color[] newColour = new Color[]{JColorChooser.showDialog(this, "Select Colour", this.colourIcon.getMainColour())};
        if (newColour != null) {
            this.colourStore.setColor(newColour[0]);
        }
    }

    public void matchColour() {
        try {
            Color colour = this.colourStore.getColour();
            this.controller.setPlotColour(colour);
            this.colourIcon.setMainColour(colour);
        }
        catch (Exception e) {}
    }

    public String getControlsTitle() {
        return this.title;
    }

    public String getControlsName() {
        return this.name;
    }

    public void reset() {
        try {
            this.colourStore.setColor(this.originalColour);
        }
        catch (Exception e) {}
    }

    public JComponent getControlsComponent() {
        return this;
    }

    public AbstractPlotControlsModel getControlsModel() {
        return this.colourStore;
    }

    public static Class getControlsModelClass() {
        return class$uk$ac$starlink$ast$gui$ColourStore == null ? (class$uk$ac$starlink$ast$gui$ColourStore = ComponentColourControls.class$("uk.ac.starlink.ast.gui.ColourStore")) : class$uk$ac$starlink$ast$gui$ColourStore;
    }

    public void stateChanged(ChangeEvent e) {
        this.matchColour();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

