/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.event.EventListenerList;
import uk.ac.starlink.ast.gui.FontChangedEvent;
import uk.ac.starlink.ast.gui.FontChangedListener;
import uk.ac.starlink.util.gui.GridBagLayouter;

public class FontControls {
    protected JComboBox styleBox = new JComboBox();
    protected JComboBox sizeBox = new JComboBox();
    protected JComboBox fontBox = new JComboBox();
    protected String currentFont;
    protected int currentSize;
    protected int currentStyle;
    protected static final String[] styleStrings = new String[]{"PLAIN", "BOLD", "ITALIC", "BOLD & ITALIC"};
    protected static final int[] styleInts = new int[]{0, 1, 2, 3};
    protected EventListenerList listeners = new EventListenerList();
    static /* synthetic */ Class class$uk$ac$starlink$ast$gui$FontChangedListener;

    public FontControls(GridBagLayouter layouter, String postfix) {
        this.initUI(layouter, postfix);
    }

    public void setDefaults() {
        this.currentFont = "Lucida Sans";
        this.currentSize = 12;
        this.currentStyle = 0;
        this.fontBox.setSelectedItem(this.currentFont);
        this.sizeBox.setSelectedItem(new Integer(this.currentSize));
        this.styleBox.setSelectedItem(styleStrings[styleInts[this.currentStyle]]);
    }

    private void initUI(GridBagLayouter layouter, String postfix) {
        layouter.add("Font:", false);
        layouter.add((Component)this.fontBox, false);
        layouter.eatLine();
        layouter.add("Style:", false);
        layouter.add((Component)this.styleBox, false);
        layouter.eatLine();
        layouter.add("Size:", false);
        layouter.add((Component)this.sizeBox, false);
        layouter.eatLine();
        this.addFonts();
        int i = 0;
        while (i < styleStrings.length) {
            this.styleBox.addItem(styleStrings[i]);
            ++i;
        }
        int i2 = 8;
        while (i2 <= 32) {
            this.sizeBox.addItem(new Integer(i2));
            ++i2;
        }
        this.setDefaults();
        this.fontBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FontControls.this.setFontName();
            }
        });
        this.sizeBox.setEditable(true);
        this.sizeBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FontControls.this.setSize();
            }
        });
        this.styleBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FontControls.this.setStyle();
            }
        });
        this.fontBox.setToolTipText("Select a font from all known");
        this.sizeBox.setToolTipText("Set the font size");
        this.styleBox.setToolTipText("Select a font style");
    }

    protected void addFonts() {
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] envfonts = gEnv.getAvailableFontFamilyNames();
        int i = 1;
        while (i < envfonts.length) {
            this.fontBox.addItem(envfonts[i]);
            ++i;
        }
    }

    protected void setFontName() {
        Object fontObj = this.fontBox.getSelectedItem();
        this.currentFont = fontObj.toString();
        this.fireChanged();
    }

    protected void setSize() {
        Object sizeObj = this.sizeBox.getSelectedItem();
        this.currentSize = sizeObj instanceof Integer ? ((Integer)sizeObj).intValue() : new Integer(sizeObj.toString()).intValue();
        this.fireChanged();
    }

    protected void setStyle() {
        String newStyle = this.styleBox.getSelectedItem().toString();
        int i = 0;
        while (i < styleStrings.length) {
            if (newStyle.equals(styleStrings[i])) {
                this.currentStyle = styleInts[i];
                break;
            }
            ++i;
        }
        this.fireChanged();
    }

    public Font getSelectedFont() {
        return new Font(this.currentFont, this.currentStyle, this.currentSize);
    }

    public void setFont(Font font) {
        if (font != null) {
            this.currentFont = font.getFamily();
            this.fontBox.setSelectedItem(this.currentFont);
            this.currentStyle = font.getStyle();
            this.styleBox.setSelectedItem(styleStrings[styleInts[this.currentStyle]]);
            this.currentSize = font.getSize();
            this.sizeBox.setSelectedItem(new Integer(this.currentSize));
        } else {
            this.setDefaults();
        }
    }

    public void addListener(FontChangedListener l) {
        this.listeners.add(class$uk$ac$starlink$ast$gui$FontChangedListener == null ? (class$uk$ac$starlink$ast$gui$FontChangedListener = FontControls.class$("uk.ac.starlink.ast.gui.FontChangedListener")) : class$uk$ac$starlink$ast$gui$FontChangedListener, l);
    }

    protected void fireChanged() {
        Object[] la = this.listeners.getListenerList();
        FontChangedEvent e = null;
        int i = la.length - 2;
        while (i >= 0) {
            if (la[i] == (class$uk$ac$starlink$ast$gui$FontChangedListener == null ? FontControls.class$("uk.ac.starlink.ast.gui.FontChangedListener") : class$uk$ac$starlink$ast$gui$FontChangedListener)) {
                if (e == null) {
                    e = new FontChangedEvent(this, this.getSelectedFont());
                }
                ((FontChangedListener)la[i + 1]).fontChanged(e);
            }
            i -= 2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

