/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;
import uk.ac.starlink.ast.gui.GraphicsEdges;
import uk.ac.starlink.ast.gui.PlotControls;
import uk.ac.starlink.ast.gui.ScientificSpinner;
import uk.ac.starlink.ast.gui.Utilities;
import uk.ac.starlink.util.gui.GridBagLayouter;

public class GraphicsEdgesControls
extends JPanel
implements PlotControls,
ChangeListener {
    protected GraphicsEdges edges = null;
    protected JCheckBox clip = new JCheckBox();
    protected ScientificSpinner xLeft = null;
    protected ScientificSpinner xRight = null;
    protected SpinnerNumberModel xLeftModel = new SpinnerNumberModel(0.0, 0.0, 0.4, 0.005);
    protected SpinnerNumberModel xRightModel = new SpinnerNumberModel(0.0, 0.0, 0.4, 0.005);
    protected ScientificSpinner yTop = null;
    protected ScientificSpinner yBottom = null;
    protected SpinnerNumberModel yTopModel = new SpinnerNumberModel(0.0, 0.0, 0.4, 0.005);
    protected SpinnerNumberModel yBottomModel = new SpinnerNumberModel(0.0, 0.0, 0.4, 0.005);
    protected static String defaultTitle = "Edge drawing properties:";
    protected static String defaultName = "Edges";
    static /* synthetic */ Class class$uk$ac$starlink$ast$gui$GraphicsEdges;

    public GraphicsEdgesControls(AbstractPlotControlsModel edges) {
        this.initUI();
        this.setGraphicsEdges((GraphicsEdges)edges);
    }

    protected void initUI() {
        this.clip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphicsEdgesControls.this.matchClip();
            }
        });
        this.xLeft = new ScientificSpinner(this.xLeftModel);
        this.xLeft.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GraphicsEdgesControls.this.matchXLeft();
            }
        });
        this.xRight = new ScientificSpinner(this.xRightModel);
        this.xRight.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GraphicsEdgesControls.this.matchXRight();
            }
        });
        this.yTop = new ScientificSpinner(this.yTopModel);
        this.yTop.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GraphicsEdgesControls.this.matchYTop();
            }
        });
        this.yBottom = new ScientificSpinner(this.yBottomModel);
        this.yBottom.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GraphicsEdgesControls.this.matchYBottom();
            }
        });
        GridBagLayouter layouter = Utilities.getGridBagLayouter(this);
        layouter.add("Clip graphics:", false);
        layouter.add((Component)this.clip, true);
        layouter.add("X left reserve:", false);
        layouter.add((Component)this.xLeft, false);
        layouter.eatLine();
        layouter.add("X right reserve:", false);
        layouter.add((Component)this.xRight, false);
        layouter.eatLine();
        layouter.add("Y top reserve:", false);
        layouter.add((Component)this.yTop, false);
        layouter.eatLine();
        layouter.add("Y bottom reserve:", false);
        layouter.add((Component)this.yBottom, false);
        layouter.eatLine();
        layouter.eatSpare();
        this.clip.setToolTipText("Clip graphics to lie within border");
        this.xLeft.setToolTipText("Set space reserved on the left for X labels (fraction)");
        this.xRight.setToolTipText("Set space reserved on the right for X labels (fraction)");
        this.yTop.setToolTipText("Set space reserved on the top for Y labels (fraction)");
        this.yBottom.setToolTipText("Set space reserved on the bottom for Y labels (fraction)");
    }

    public void setGraphicsEdges(GraphicsEdges edges) {
        this.edges = edges;
        edges.addChangeListener(this);
        this.updateFromGraphicsEdges();
    }

    protected void updateFromGraphicsEdges() {
        this.edges.removeChangeListener(this);
        this.clip.setSelected(this.edges.isClipped());
        this.xLeftModel.setValue(new Double(this.edges.getXLeft()));
        this.xRightModel.setValue(new Double(this.edges.getXRight()));
        this.yTopModel.setValue(new Double(this.edges.getYTop()));
        this.yBottomModel.setValue(new Double(this.edges.getYBottom()));
        this.edges.addChangeListener(this);
    }

    public GraphicsEdges getGraphicsEdges() {
        return this.edges;
    }

    protected void matchClip() {
        this.edges.setClipped(this.clip.isSelected());
    }

    protected void matchXLeft() {
        this.edges.setXLeft(this.xLeftModel.getNumber().doubleValue());
    }

    protected void matchXRight() {
        this.edges.setXRight(this.xRightModel.getNumber().doubleValue());
    }

    protected void matchYTop() {
        this.edges.setYTop(this.yTopModel.getNumber().doubleValue());
    }

    protected void matchYBottom() {
        this.edges.setYBottom(this.yBottomModel.getNumber().doubleValue());
    }

    public String getControlsTitle() {
        return defaultTitle;
    }

    public String getControlsName() {
        return defaultName;
    }

    public void reset() {
        this.edges.setDefaults();
    }

    public JComponent getControlsComponent() {
        return this;
    }

    public AbstractPlotControlsModel getControlsModel() {
        return this.edges;
    }

    public static Class getControlsModelClass() {
        return class$uk$ac$starlink$ast$gui$GraphicsEdges == null ? (class$uk$ac$starlink$ast$gui$GraphicsEdges = GraphicsEdgesControls.class$("uk.ac.starlink.ast.gui.GraphicsEdges")) : class$uk$ac$starlink$ast$gui$GraphicsEdges;
    }

    public void stateChanged(ChangeEvent e) {
        this.updateFromGraphicsEdges();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

