/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Vector;

public class ScientificFormat
extends NumberFormat {
    protected DecimalFormat efmt = null;
    protected DecimalFormat dfmt = null;
    protected int maxwidth = 0;
    boolean parseMatissaOnly = false;
    boolean flexmode = true;
    boolean expmode = false;
    boolean decmode = false;
    protected static final String defdfmt = "#0.####;-#0.####";
    protected static final String defefmt = "E+#0;E-#0";
    public static final int EXPONENT_FIELD = 3;

    public ScientificFormat() {
        this(Locale.ENGLISH);
    }

    public ScientificFormat(Locale locale) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(locale);
        this.dfmt = new DecimalFormat(defdfmt, dfs);
        this.efmt = new DecimalFormat(defefmt, dfs);
    }

    public ScientificFormat(String pattern) {
        this();
        this.applyPattern(pattern);
    }

    public ScientificFormat(Locale locale, String pattern) {
        this(locale);
        this.applyPattern(pattern);
    }

    public void applyPattern(String pattern) throws IllegalArgumentException {
        String sub;
        int l;
        int p;
        Vector qpos;
        Vector quoteds;
        String pat;
        block20: {
            Object[] fmtquotes = ScientificFormat.extractQuotedStrings(pattern);
            pat = (String)fmtquotes[0];
            quoteds = (Vector)fmtquotes[1];
            qpos = (Vector)fmtquotes[2];
            p = pat.indexOf(94);
            if (p != (l = pat.lastIndexOf(94))) {
                throw new IllegalArgumentException("Bad formatting string: too many ^s");
            }
            try {
                sub = pat.substring(p + 1).trim();
                pat = pat.substring(0, p).trim();
                if (sub == null || sub.length() <= 0) break block20;
                if (sub.indexOf(46) >= 0) {
                    throw new IllegalArgumentException("Bad formatting string: integer exponents only");
                }
                String epat = ScientificFormat.replaceQuotedStrings(quoteds, qpos, sub, p + 1);
                try {
                    this.efmt.applyPattern(epat);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("Bad formatting string: bad exponent portion: " + epat);
                }
            }
            catch (StringIndexOutOfBoundsException ex) {
                // empty catch block
            }
        }
        p = pat.indexOf(58);
        l = pat.lastIndexOf(58);
        if (p != l) {
            throw new IllegalArgumentException("Bad formatting string: too many :s");
        }
        this.maxwidth = 0;
        try {
            sub = pat.substring(p + 1).trim();
            pat = pat.substring(0, p).trim();
            if (sub != null && sub.length() > 0) {
                this.maxwidth = Integer.parseInt(sub);
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Bad formatting string: bad max-width value");
        }
        catch (StringIndexOutOfBoundsException ex) {
            // empty catch block
        }
        p = 1;
        if (pat.charAt(0) == '!') {
            this.setExponentialMode();
        } else if (pat.charAt(0) == '~') {
            this.setFlexibleMode();
        } else {
            this.setDecimalMode();
            if (pat.charAt(0) != '@') {
                p = 0;
            }
        }
        try {
            sub = p > 0 ? pat.substring(p) : pat;
            pat = ScientificFormat.replaceQuotedStrings(quoteds, qpos, sub, p);
            try {
                this.dfmt.applyPattern(pat);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Bad formatting string: bad decimal portion: " + pat);
            }
        }
        catch (StringIndexOutOfBoundsException ex) {}
    }

    /*
     * WARNING - void declaration
     */
    protected static Object[] extractQuotedStrings(String text) {
        int bp;
        Object[] out = new Object[3];
        Vector<String> qstrs = new Vector<String>();
        Vector<Integer> qpos = new Vector<Integer>();
        StringBuffer ostr = new StringBuffer();
        out[1] = qstrs;
        out[2] = qpos;
        int ppos = 0;
        int nl = 0;
        while (ppos < text.length() && (bp = text.indexOf("'", ppos)) >= 0) {
            void var6_7;
            void al = var6_7 - ppos;
            int opp = ppos;
            ppos = text.indexOf("'", (int)(var6_7 + true));
            if (ppos < 0) break;
            ostr.append(text.substring(ppos, (int)(var6_7 - ppos)));
            qstrs.addElement(text.substring((int)var6_7, 1 + ppos - var6_7));
            qpos.addElement(new Integer(nl += al));
        }
        ostr.append(text.substring(ppos));
        out[0] = ostr.toString();
        return out;
    }

    protected static String replaceQuotedStrings(Vector strings, Vector positions, String input, int start) {
        if (strings == null || strings.size() == 0) {
            return input;
        }
        int b = 0;
        StringBuffer out = new StringBuffer();
        int n = Math.min(strings.size(), positions.size());
        int i = 0;
        while (i < n) {
            int p = (Integer)positions.elementAt(i) - start;
            if (start >= 0 && p < input.length()) {
                out.append(input.substring(b, p - b));
                out.append((String)strings.elementAt(i));
                b = p;
            }
            ++i;
        }
        out.append(input.substring(b));
        return out.toString();
    }

    public void applyLocalizedPattern(String pattern) {
        this.applyPattern(pattern);
    }

    public void applyMantissaPattern(String pattern) {
        this.dfmt.applyPattern(pattern);
    }

    public void applyExponentPattern(String pattern) {
        this.efmt.applyPattern(pattern);
    }

    public void setMaxWidth(int width) {
        this.maxwidth = width > 0 ? width : 0;
    }

    public int getMaxWidth() {
        if (this.maxwidth > 0) {
            return this.maxwidth;
        }
        return Math.max(this.getPositivePrefix().length(), this.getNegativePrefix().length()) + Math.max(this.getPositiveSuffix().length(), this.getNegativeSuffix().length()) + this.getMaximumFractionDigits() + Math.max(this.getMinimumIntegerDigits(), 3) + 1;
    }

    public String getPositivePrefix() {
        return this.dfmt.getPositivePrefix();
    }

    public void setPositivePrefix(String newValue) {
        this.dfmt.setPositivePrefix(newValue);
    }

    public String getNegativePrefix() {
        return this.dfmt.getNegativePrefix();
    }

    public void setNegativePrefix(String newValue) {
        this.dfmt.setNegativePrefix(newValue);
    }

    public String getPositiveSuffix() {
        return this.dfmt.getPositiveSuffix();
    }

    public void setPositiveSuffix(String newValue) {
        this.dfmt.setPositiveSuffix(newValue);
    }

    public String getNegativeSuffix() {
        return this.dfmt.getNegativeSuffix();
    }

    public void setNegativeSuffix(String newValue) {
        this.dfmt.setNegativeSuffix(newValue);
    }

    public String getExpPositivePrefix() {
        return this.efmt.getPositivePrefix();
    }

    public void setExpPositivePrefix(String newValue) {
        this.efmt.setPositivePrefix(newValue);
    }

    public String getExpNegativePrefix() {
        return this.efmt.getNegativePrefix();
    }

    public void setExpNegativePrefix(String newValue) {
        this.efmt.setNegativePrefix(newValue);
    }

    public String getExpPositiveSuffix() {
        return this.efmt.getPositiveSuffix();
    }

    public void setExpPositiveSuffix(String newValue) {
        this.efmt.setPositiveSuffix(newValue);
    }

    public String getExpNegativeSuffix() {
        return this.efmt.getNegativeSuffix();
    }

    public void setExpNegativeSuffix(String newValue) {
        this.efmt.setNegativeSuffix(newValue);
    }

    public void setExponentialMode() {
        this.expmode = true;
        this.flexmode = false;
        this.decmode = false;
    }

    public boolean isExponentialMode() {
        return this.expmode;
    }

    public void setDecimalMode() {
        this.decmode = true;
        this.flexmode = false;
        this.expmode = false;
    }

    public boolean isDecimalMode() {
        return this.decmode;
    }

    public void setFlexibleMode() {
        this.flexmode = true;
        this.expmode = false;
        this.decmode = false;
    }

    public boolean isFlexibleMode() {
        return this.flexmode;
    }

    public int getGroupingSize() {
        return this.dfmt.getGroupingSize();
    }

    public void setGroupingSize(int newValue) {
        this.dfmt.setGroupingSize(newValue);
    }

    public int getExpGroupingSize() {
        return this.dfmt.getGroupingSize();
    }

    public void setExpGroupingSize(int newValue) {
        this.dfmt.setGroupingSize(newValue);
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.dfmt.isDecimalSeparatorAlwaysShown();
    }

    public void setDecimalSeparatorAlwaysShown(boolean newValue) {
        this.dfmt.setDecimalSeparatorAlwaysShown(newValue);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ScientificFormat)) {
            return false;
        }
        ScientificFormat that = (ScientificFormat)obj;
        if (this.decmode != that.decmode || this.expmode != that.expmode || this.flexmode != that.flexmode) {
            return false;
        }
        if (!this.dfmt.equals(that.dfmt)) {
            return false;
        }
        if (!this.decmode && !this.efmt.equals(that.efmt)) {
            return false;
        }
        return !this.flexmode || this.maxwidth == that.maxwidth;
    }

    public Object clone() {
        ScientificFormat out = (ScientificFormat)super.clone();
        out.dfmt = (DecimalFormat)this.dfmt.clone();
        out.efmt = (DecimalFormat)this.efmt.clone();
        return out;
    }

    public String toPattern() {
        StringBuffer out = new StringBuffer();
        if (this.expmode) {
            out.append("!");
        } else if (this.flexmode) {
            out.append("~");
        } else {
            out.append("@");
        }
        out.append(this.dfmt.toPattern());
        if (this.flexmode) {
            out.append(":" + this.maxwidth);
        }
        if (!this.decmode) {
            out.append("^" + this.efmt.toPattern());
        }
        return out.toString();
    }

    public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
        if (this.expmode) {
            return this.exponentialFormat(number, result, fieldPosition);
        }
        if (this.flexmode) {
            int sign = number < 0.0 ? -1 : 1;
            int mxwd = this.getMaxWidth();
            double mantissa = Math.abs(number);
            double exponent = 0.0;
            if (mantissa != 0.0) {
                while (mantissa > 10.0) {
                    mantissa /= 10.0;
                    exponent += 1.0;
                }
                while (mantissa < 1.0) {
                    mantissa *= 10.0;
                    exponent -= 1.0;
                }
            }
            if (exponent < (double)(1 - this.dfmt.getMaximumFractionDigits()) || exponent - (double)this.dfmt.getMaximumFractionDigits() > (double)(mxwd - 2)) {
                return this.exponentialFormat((double)sign * mantissa, exponent, result, fieldPosition);
            }
            StringBuffer tmp = new StringBuffer();
            this.dfmt.format(number, tmp, fieldPosition);
            if (tmp.length() > mxwd) {
                return this.exponentialFormat((double)sign * mantissa, exponent, result, fieldPosition);
            }
            result.append(tmp.toString());
            return result;
        }
        return this.dfmt.format(number, result, fieldPosition);
    }

    public StringBuffer format(long number, StringBuffer result, FieldPosition fieldPosition) {
        if (this.expmode) {
            return this.exponentialFormat(number, result, fieldPosition);
        }
        if (this.flexmode) {
            int sign = number < 0L ? -1 : 1;
            int mxwd = this.getMaxWidth();
            double mantissa = Math.abs(number);
            double exponent = 0.0;
            if (mantissa != 0.0) {
                while (mantissa > 10.0) {
                    mantissa /= 10.0;
                    exponent += 1.0;
                }
                while (mantissa < 1.0) {
                    mantissa *= 10.0;
                    exponent -= 1.0;
                }
            }
            if (exponent < (double)(1 - this.dfmt.getMaximumFractionDigits()) || exponent - (double)this.dfmt.getMaximumFractionDigits() > (double)(mxwd - 2)) {
                return this.exponentialFormat((double)sign * mantissa, exponent, result, fieldPosition);
            }
            StringBuffer tmp = new StringBuffer();
            this.dfmt.format(number, tmp, fieldPosition);
            if (tmp.length() > mxwd) {
                return this.exponentialFormat((double)sign * mantissa, exponent, result, fieldPosition);
            }
            result.append(tmp.toString());
            return result;
        }
        return this.dfmt.format(number, result, fieldPosition);
    }

    private StringBuffer exponentialFormat(double mantissa, double exponent, StringBuffer result, FieldPosition fieldPosition) {
        FieldPosition euse;
        FieldPosition ruse;
        FieldPosition intfp = new FieldPosition(0);
        if (fieldPosition.getField() == 3) {
            ruse = intfp;
            euse = fieldPosition;
        } else {
            ruse = fieldPosition;
            euse = intfp;
        }
        this.dfmt.format(mantissa, result, ruse);
        this.efmt.format(exponent, result, euse);
        return result;
    }

    private StringBuffer exponentialFormat(double number, StringBuffer result, FieldPosition fieldPosition) {
        int exp = 0;
        int sign = number < 0.0 ? -1 : 1;
        number = Math.abs(number);
        while (number > 10.0) {
            number /= 10.0;
            ++exp;
        }
        while (number < 1.0) {
            number *= 10.0;
            --exp;
        }
        return this.exponentialFormat((double)sign * number, exp, result, fieldPosition);
    }

    private StringBuffer exponentialFormat(long number, StringBuffer result, FieldPosition fieldPosition) {
        FieldPosition euse;
        FieldPosition ruse;
        int exp = 0;
        FieldPosition intfp = new FieldPosition(0);
        while (number > 10L) {
            number /= 10L;
            ++exp;
        }
        while (number < 1L) {
            number *= 10L;
            --exp;
        }
        if (fieldPosition.getField() == 3) {
            ruse = intfp;
            euse = fieldPosition;
        } else {
            ruse = fieldPosition;
            euse = intfp;
        }
        this.dfmt.format(number, result, ruse);
        this.efmt.format((long)exp, result, euse);
        return result;
    }

    public Number parse(String text, ParsePosition parsePosition) {
        if (this.expmode) {
            return this.parseAsExponential(text, parsePosition);
        }
        if (this.flexmode) {
            return this.parseAsFlexible(text, parsePosition);
        }
        return this.parseAsDecimal(text, parsePosition);
    }

    public Number parseAsExponential(String text, ParsePosition parsePosition) {
        Number expo;
        Number out = null;
        int start = parsePosition.getIndex();
        Number mantissa = this.dfmt.parse(text, parsePosition);
        if (mantissa == null) {
            return null;
        }
        if (this.isParseIntegerOnly()) {
            return mantissa;
        }
        int p = parsePosition.getIndex() - 1;
        if (p >= 0 && text.charAt(p) == 'E') {
            parsePosition.setIndex(p);
        }
        if ((expo = this.efmt.parse(text, parsePosition)) == null) {
            parsePosition.setIndex(start);
            return null;
        }
        double val = mantissa.doubleValue() * Math.pow(10.0, expo.doubleValue());
        out = mantissa instanceof Long && expo instanceof Long ? (Number)new Long(Math.round(val)) : (Number)new Double(val);
        return out;
    }

    public Number parseAsDecimal(String text, ParsePosition parsePosition) {
        return this.dfmt.parse(text, parsePosition);
    }

    public Number parseAsFlexible(String text, ParsePosition parsePosition) {
        Number out = this.parseAsExponential(text, parsePosition);
        if (out != null) {
            return out;
        }
        return this.parseAsDecimal(text, parsePosition);
    }

    public void setParseIntegerOnly(boolean value) {
        super.setParseIntegerOnly(value);
        this.dfmt.setParseIntegerOnly(value);
    }

    public boolean isGroupingUsed() {
        return this.dfmt.isGroupingUsed();
    }

    public void setGroupingUsed(boolean newValue) {
        this.dfmt.setGroupingUsed(newValue);
    }

    public int getMaximumIntegerDigits() {
        return this.dfmt.getMaximumIntegerDigits();
    }

    public void setMaximumIntegerDigits(int newValue) {
        this.dfmt.setMaximumIntegerDigits(newValue);
    }

    public int getMinimumIntegerDigits() {
        return this.dfmt.getMinimumIntegerDigits();
    }

    public void setMinimumIntegerDigits(int newValue) {
        this.dfmt.setMinimumIntegerDigits(newValue);
    }

    public int getMaximumFractionDigits() {
        return this.dfmt.getMaximumFractionDigits();
    }

    public void setMaximumFractionDigits(int newValue) {
        this.dfmt.setMaximumFractionDigits(newValue);
    }

    public int getMinimumFractionDigits() {
        return this.dfmt.getMinimumFractionDigits();
    }

    public void setMinimumFractionDigits(int newValue) {
        this.dfmt.setMinimumFractionDigits(newValue);
    }

    public int getExpMaximumIntegerDigits() {
        return this.efmt.getMaximumIntegerDigits();
    }

    public void setExpMaximumIntegerDigits(int newValue) {
        this.efmt.setMaximumIntegerDigits(newValue);
    }

    public int getExpMinimumIntegerDigits() {
        return this.efmt.getMinimumIntegerDigits();
    }

    public void setExpMinimumIntegerDigits(int newValue) {
        this.efmt.setMinimumIntegerDigits(newValue);
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0 || args[0].equals("")) {
            args = new String[]{"5.428E+2"};
        }
        ScientificFormat scifmt = new ScientificFormat();
        ParsePosition ppos = new ParsePosition(0);
        System.out.println("Maximum width for Flexible Mode: " + scifmt.getMaxWidth());
        System.out.println("Input\t\tFlexible\tDecimal\tExponential");
        int i = 0;
        while (i < args.length) {
            StringBuffer buf = new StringBuffer(args[i]);
            System.out.println("Parsing: " + buf.toString());
            ppos.setIndex(0);
            scifmt.setFlexibleMode();
            Number num = scifmt.parse(args[i], ppos);
            if (ppos.getIndex() == 0) {
                buf.append("\tUnable to parse out number");
                System.out.println(buf.toString());
            } else {
                double value = num.doubleValue();
                buf.append("\t\t").append(scifmt.format(value));
                scifmt.setDecimalMode();
                buf.append("\t").append(scifmt.format(value));
                scifmt.setExponentialMode();
                buf.append("\t").append(scifmt.format(value));
                System.out.println(buf.toString());
            }
            ++i;
        }
    }
}

