/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;
import uk.ac.starlink.ast.gui.AstStrings;
import uk.ac.starlink.ast.gui.ColourIcon;
import uk.ac.starlink.ast.gui.FontChangedEvent;
import uk.ac.starlink.ast.gui.FontChangedListener;
import uk.ac.starlink.ast.gui.FontControls;
import uk.ac.starlink.ast.gui.PlotControls;
import uk.ac.starlink.ast.gui.Utilities;
import uk.ac.starlink.util.gui.GridBagLayouter;

public class StringsControls
extends JPanel
implements PlotControls,
ChangeListener {
    protected AstStrings astStrings = null;
    protected JLabel sampleText = new JLabel("The quick brown fox");
    protected JButton colourButton = new JButton();
    protected ColourIcon colourIcon = new ColourIcon(Color.black);
    protected FontControls fontControls = null;
    protected static String defaultTitle = "General text properties:";
    protected static String defaultName = "Text";
    static /* synthetic */ Class class$uk$ac$starlink$ast$gui$AstStrings;

    public StringsControls(AbstractPlotControlsModel astStrings) {
        this.initUI();
        this.setAstStrings((AstStrings)astStrings);
    }

    protected void initUI() {
        this.colourButton.setIcon(this.colourIcon);
        this.colourButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StringsControls.this.chooseColour();
            }
        });
        GridBagLayouter layouter = Utilities.getGridBagLayouter(this);
        layouter.add("Sample:", false);
        layouter.add((Component)this.sampleText, true);
        this.addFontControls(layouter);
        layouter.add("Colour:", false);
        layouter.add((Component)this.colourButton, false);
        layouter.eatLine();
        layouter.eatSpare();
        this.colourButton.setToolTipText("Select a colour");
    }

    public void setAstStrings(AstStrings astStrings) {
        this.astStrings = astStrings;
        astStrings.addChangeListener(this);
        this.updateFromAstStrings();
    }

    protected void updateFromAstStrings() {
        this.astStrings.removeChangeListener(this);
        this.sampleText.setFont(this.astStrings.getFont());
        this.fontControls.setFont(this.astStrings.getFont());
        this.sampleText.setForeground(this.astStrings.getColour());
        this.colourIcon.setMainColour(this.astStrings.getColour());
        this.colourButton.repaint();
        this.astStrings.addChangeListener(this);
    }

    public AstStrings getAstStrings() {
        return this.astStrings;
    }

    private void addFontControls(GridBagLayouter layouter) {
        this.fontControls = new FontControls(layouter, "");
        this.fontControls.addListener(new FontChangedListener(){

            public void fontChanged(FontChangedEvent e) {
                StringsControls.this.updateFont(e);
            }
        });
    }

    protected void updateFont(FontChangedEvent e) {
        this.setTextFont(e.getFont());
    }

    protected void setTextFont(Font font) {
        this.astStrings.setFont(font);
    }

    protected void chooseColour() {
        Color newColour = JColorChooser.showDialog(this, "Select text colour", this.colourIcon.getMainColour());
        if (newColour != null) {
            this.setTextColour(newColour);
        }
    }

    protected void setTextColour(Color colour) {
        if (colour != null) {
            this.astStrings.setColour(colour);
        }
    }

    public String getControlsTitle() {
        return defaultTitle;
    }

    public String getControlsName() {
        return defaultName;
    }

    public void reset() {
        this.fontControls.setDefaults();
        this.setTextColour(Color.black);
        this.astStrings.setDefaults();
    }

    public JComponent getControlsComponent() {
        return this;
    }

    public AbstractPlotControlsModel getControlsModel() {
        return this.astStrings;
    }

    public static Class getControlsModelClass() {
        return class$uk$ac$starlink$ast$gui$AstStrings == null ? (class$uk$ac$starlink$ast$gui$AstStrings = StringsControls.class$("uk.ac.starlink.ast.gui.AstStrings")) : class$uk$ac$starlink$ast$gui$AstStrings;
    }

    public void stateChanged(ChangeEvent e) {
        this.updateFromAstStrings();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

