/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;
import uk.ac.starlink.ast.gui.AstDoubleField;
import uk.ac.starlink.ast.gui.AstTicks;
import uk.ac.starlink.ast.gui.LineControls;
import uk.ac.starlink.ast.gui.PlotController;
import uk.ac.starlink.ast.gui.PlotControls;
import uk.ac.starlink.ast.gui.ScientificSpinner;
import uk.ac.starlink.ast.gui.Utilities;
import uk.ac.starlink.util.gui.GridBagLayouter;

public class TickControls
extends JPanel
implements PlotControls,
ChangeListener {
    protected AstTicks astTicks = null;
    protected PlotController controller = null;
    protected JCheckBox show = new JCheckBox();
    protected JCheckBox logSpacingSet = new JCheckBox();
    protected JCheckBox xLogSpacing = new JCheckBox();
    protected JCheckBox yLogSpacing = new JCheckBox();
    protected ScientificSpinner xLogGap = null;
    protected SpinnerNumberModel xLogGapModel = new SpinnerNumberModel(0, 0, 10, 1);
    protected ScientificSpinner yLogGap = null;
    protected SpinnerNumberModel yLogGapModel = new SpinnerNumberModel(0, 0, 10, 1);
    protected AstDoubleField xMajorGap = null;
    protected AstDoubleField yMajorGap = null;
    protected ScientificSpinner xMajorLength = null;
    protected SpinnerNumberModel xMajorLengthModel = new SpinnerNumberModel(0.0, -0.1, 0.1, 0.005);
    protected ScientificSpinner yMajorLength = null;
    protected SpinnerNumberModel yMajorLengthModel = new SpinnerNumberModel(0.0, -0.1, 0.1, 0.005);
    protected ScientificSpinner xMinorLength = null;
    protected SpinnerNumberModel xMinorLengthModel = new SpinnerNumberModel(0.0, -0.1, 0.1, 0.005);
    protected ScientificSpinner yMinorLength = null;
    protected SpinnerNumberModel yMinorLengthModel = new SpinnerNumberModel(0.0, -0.1, 0.1, 0.005);
    protected JComboBox xMinorDivisions = new JComboBox();
    protected JComboBox yMinorDivisions = new JComboBox();
    protected JCheckBox tickAll = new JCheckBox();
    protected LineControls lineControls = null;
    protected boolean inhibitLineChangeListener = false;
    protected static String defaultTitle = "Tick properties:";
    protected static String defaultName = "Ticks";
    static /* synthetic */ Class class$uk$ac$starlink$ast$gui$AstTicks;

    public TickControls(AbstractPlotControlsModel astTicks, PlotController controller) {
        this.controller = controller;
        this.initUI();
        this.setAstTicks((AstTicks)astTicks);
    }

    protected void initUI() {
        this.show.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TickControls.this.matchShow();
            }
        });
        this.logSpacingSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TickControls.this.matchLogSpacingSet();
            }
        });
        this.xLogSpacing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TickControls.this.matchXLogSpacing();
            }
        });
        this.yLogSpacing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TickControls.this.matchYLogSpacing();
            }
        });
        this.xLogGap = new ScientificSpinner(this.xLogGapModel);
        this.xLogGap.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TickControls.this.matchXLogGap();
            }
        });
        this.yLogGap = new ScientificSpinner(this.yLogGapModel);
        this.yLogGap.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TickControls.this.matchYLogGap();
            }
        });
        this.xMajorGap = new AstDoubleField(0.0, this.controller, 1);
        this.xMajorGap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TickControls.this.matchXMajorGap();
            }
        });
        this.yMajorGap = new AstDoubleField(0.0, this.controller, 2);
        this.yMajorGap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TickControls.this.matchYMajorGap();
            }
        });
        this.xMajorLength = new ScientificSpinner(this.xMajorLengthModel);
        this.xMajorLength.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TickControls.this.matchXMajorLength();
            }
        });
        this.yMajorLength = new ScientificSpinner(this.yMajorLengthModel);
        this.yMajorLength.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TickControls.this.matchYMajorLength();
            }
        });
        this.xMinorLength = new ScientificSpinner(this.xMinorLengthModel);
        this.xMinorLength.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TickControls.this.matchXMinorLength();
            }
        });
        this.yMinorLength = new ScientificSpinner(this.yMinorLengthModel);
        this.yMinorLength.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TickControls.this.matchYMinorLength();
            }
        });
        this.xMinorDivisions.addItem("Default");
        int i = 1;
        while (i < 21) {
            this.xMinorDivisions.addItem(new Integer(i));
            ++i;
        }
        this.xMinorDivisions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TickControls.this.matchXMinorDivisions();
            }
        });
        this.yMinorDivisions.addItem("Default");
        int i2 = 1;
        while (i2 < 21) {
            this.yMinorDivisions.addItem(new Integer(i2));
            ++i2;
        }
        this.yMinorDivisions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TickControls.this.matchYMinorDivisions();
            }
        });
        this.tickAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TickControls.this.matchTickAll();
            }
        });
        GridBagLayouter layouter = Utilities.getGridBagLayouter(this);
        layouter.add("Show ticks:", false);
        layouter.add((Component)this.show, true);
        layouter.add("X spacing:", false);
        layouter.add((Component)this.xMajorGap, true);
        layouter.add("Y spacing:", false);
        layouter.add((Component)this.yMajorGap, true);
        layouter.add("Set log spacing:", false);
        layouter.add((Component)this.logSpacingSet, true);
        layouter.add("X log spacing:", false);
        layouter.add((Component)this.xLogSpacing, true);
        layouter.add("Y log spacing:", false);
        layouter.add((Component)this.yLogSpacing, true);
        layouter.add("X log gap:", false);
        layouter.add((Component)this.xLogGap, false);
        layouter.eatLine();
        layouter.add("Y log gap:", false);
        layouter.add((Component)this.yLogGap, false);
        layouter.eatLine();
        this.addLineControls(layouter);
        layouter.add("X major len:", false);
        layouter.add((Component)this.xMajorLength, false);
        layouter.eatLine();
        layouter.add("Y major len:", false);
        layouter.add((Component)this.yMajorLength, false);
        layouter.eatLine();
        layouter.add("X minor len:", false);
        layouter.add((Component)this.xMinorLength, false);
        layouter.eatLine();
        layouter.add("Y minor len:", false);
        layouter.add((Component)this.yMinorLength, false);
        layouter.eatLine();
        layouter.add("X divisions:", false);
        layouter.add((Component)this.xMinorDivisions, false);
        layouter.eatLine();
        layouter.add("Y divisions:", false);
        layouter.add((Component)this.yMinorDivisions, false);
        layouter.eatLine();
        layouter.add("Tick all:", false);
        layouter.add((Component)this.tickAll, true);
        layouter.eatSpare();
        this.show.setToolTipText("Show tick marks in plot");
        this.logSpacingSet.setToolTipText("Use log spacing settings to override defaults");
        this.xLogSpacing.setToolTipText("Use log spacing for X axis ticks");
        this.yLogSpacing.setToolTipText("Use log spacing for Y axis ticks");
        this.xLogGap.setToolTipText("Gap ratio for major ticks when X is log axis, <Return> to accept");
        this.yLogGap.setToolTipText("Gap ratio for major ticks when Y is log axis, <Return> to accept");
        this.xMajorGap.setToolTipText("Gap between major ticks (units of X axis), <Return> to accept");
        this.yMajorGap.setToolTipText("Gap between major ticks (units of Y axis), <Return> to accept");
        this.xMajorLength.setToolTipText("Length of X major tick marks");
        this.yMajorLength.setToolTipText("Length of Y major tick marks");
        this.xMinorLength.setToolTipText("Length of X minor tick marks");
        this.yMinorLength.setToolTipText("Length of Y minor tick marks");
        this.xMinorDivisions.setToolTipText("Number of divisions between major ticks");
        this.yMinorDivisions.setToolTipText("Number of divisions between major ticks");
        this.tickAll.setToolTipText("Add ticks to all axes");
    }

    public void setAstTicks(AstTicks astTicks) {
        this.astTicks = astTicks;
        astTicks.addChangeListener(this);
        this.updateFromAstTicks();
    }

    protected void updateFromAstTicks() {
        this.astTicks.removeChangeListener(this);
        this.show.setSelected(this.astTicks.getShown());
        this.logSpacingSet.setSelected(this.astTicks.getLogSpacingSet());
        this.xLogSpacing.setSelected(this.astTicks.getXLogSpacing());
        this.yLogSpacing.setSelected(this.astTicks.getYLogSpacing());
        this.matchLogSpacingSet();
        this.xLogGap.setValue(new Integer(this.astTicks.getXLogGap()));
        this.yLogGap.setValue(new Integer(this.astTicks.getYLogGap()));
        this.inhibitLineChangeListener = true;
        this.lineControls.setThick((int)this.astTicks.getWidth());
        this.lineControls.setColour(this.astTicks.getColour());
        this.lineControls.setStyle((int)this.astTicks.getStyle());
        this.inhibitLineChangeListener = false;
        this.xMajorGap.setDoubleValue(this.astTicks.getXGap());
        this.yMajorGap.setDoubleValue(this.astTicks.getYGap());
        this.xMajorLengthModel.setValue(new Double(this.astTicks.getMajorXTicklength()));
        this.yMajorLengthModel.setValue(new Double(this.astTicks.getMajorYTicklength()));
        this.xMinorLengthModel.setValue(new Double(this.astTicks.getMinorXTicklength()));
        this.yMinorLengthModel.setValue(new Double(this.astTicks.getMinorYTicklength()));
        int div = this.astTicks.getMinorXDivisions();
        if (div == 0) {
            this.xMinorDivisions.setSelectedItem("Default");
        } else {
            this.xMinorDivisions.setSelectedItem(new Integer(div));
        }
        div = this.astTicks.getMinorYDivisions();
        if (div == 0) {
            this.yMinorDivisions.setSelectedItem("Default");
        } else {
            this.yMinorDivisions.setSelectedItem(new Integer(div));
        }
        this.tickAll.setSelected(this.astTicks.getTickAll());
        this.astTicks.setState(true);
        this.astTicks.addChangeListener(this);
    }

    public AstTicks getAstTicks() {
        return this.astTicks;
    }

    private void addLineControls(GridBagLayouter layouter) {
        this.lineControls = new LineControls(layouter, "");
        this.lineControls.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TickControls.this.matchLine();
            }
        });
    }

    protected void matchShow() {
        this.astTicks.setShown(this.show.isSelected());
    }

    protected void matchLogSpacingSet() {
        boolean set = this.logSpacingSet.isSelected();
        this.astTicks.setLogSpacingSet(set);
        this.xLogSpacing.setEnabled(set);
        this.yLogSpacing.setEnabled(set);
        this.xLogGap.setEnabled(set);
        this.yLogGap.setEnabled(set);
    }

    protected void matchXLogSpacing() {
        this.astTicks.setXLogSpacing(this.xLogSpacing.isSelected());
    }

    protected void matchYLogSpacing() {
        this.astTicks.setYLogSpacing(this.yLogSpacing.isSelected());
    }

    protected void matchXLogGap() {
        this.astTicks.setXLogGap(this.xLogGapModel.getNumber().intValue());
    }

    protected void matchYLogGap() {
        this.astTicks.setYLogGap(this.yLogGapModel.getNumber().intValue());
    }

    protected void matchLine() {
        if (!this.inhibitLineChangeListener) {
            this.astTicks.removeChangeListener(this);
            this.astTicks.setWidth(this.lineControls.getThick());
            this.astTicks.setStyle(this.lineControls.getStyle());
            this.astTicks.setColour(this.lineControls.getColour());
            this.astTicks.addChangeListener(this);
            this.updateFromAstTicks();
        }
    }

    protected void matchXMajorGap() {
        this.astTicks.setXGap(this.xMajorGap.getDoubleValue());
    }

    protected void matchYMajorGap() {
        this.astTicks.setYGap(this.yMajorGap.getDoubleValue());
    }

    protected void matchXMajorLength() {
        this.astTicks.setMajorXTicklength(this.xMajorLengthModel.getNumber().doubleValue());
    }

    protected void matchYMajorLength() {
        this.astTicks.setMajorYTicklength(this.yMajorLengthModel.getNumber().doubleValue());
    }

    protected void matchXMinorLength() {
        this.astTicks.setMinorXTicklength(this.xMinorLengthModel.getNumber().doubleValue());
    }

    protected void matchYMinorLength() {
        this.astTicks.setMinorYTicklength(this.yMinorLengthModel.getNumber().doubleValue());
    }

    protected void matchXMinorDivisions() {
        Object object = this.xMinorDivisions.getSelectedItem();
        int value = 0;
        if (!object.equals("Default")) {
            value = (Integer)object;
        }
        this.astTicks.setMinorXDivisions(value);
    }

    protected void matchYMinorDivisions() {
        Object object = this.yMinorDivisions.getSelectedItem();
        int value = 0;
        if (!object.equals("Default")) {
            value = (Integer)object;
        }
        this.astTicks.setMinorYDivisions(value);
    }

    protected void matchTickAll() {
        this.astTicks.setTickAll(this.tickAll.isSelected());
    }

    public String getControlsTitle() {
        return defaultTitle;
    }

    public String getControlsName() {
        return defaultName;
    }

    public void reset() {
        this.lineControls.reset();
        this.astTicks.setDefaults();
        this.updateFromAstTicks();
    }

    public JComponent getControlsComponent() {
        return this;
    }

    public AbstractPlotControlsModel getControlsModel() {
        return this.astTicks;
    }

    public static Class getControlsModelClass() {
        return class$uk$ac$starlink$ast$gui$AstTicks == null ? (class$uk$ac$starlink$ast$gui$AstTicks = TickControls.class$("uk.ac.starlink.ast.gui.AstTicks")) : class$uk$ac$starlink$ast$gui$AstTicks;
    }

    public void stateChanged(ChangeEvent e) {
        this.updateFromAstTicks();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

