/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardCategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public abstract class AbstractCategoryItemRenderer
implements CategoryItemRenderer {
    protected ChartRenderingInfo info;
    protected CategoryToolTipGenerator toolTipGenerator;

    protected AbstractCategoryItemRenderer() {
        this(new StandardCategoryToolTipGenerator());
    }

    protected AbstractCategoryItemRenderer(CategoryToolTipGenerator categoryToolTipGenerator) {
        this.toolTipGenerator = categoryToolTipGenerator;
        this.info = null;
    }

    public CategoryToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(CategoryToolTipGenerator categoryToolTipGenerator) {
        this.toolTipGenerator = categoryToolTipGenerator;
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, ChartRenderingInfo chartRenderingInfo) {
        this.info = chartRenderingInfo;
    }

    public boolean isStacked() {
        return false;
    }

    public Rectangle2D getAxisArea(Rectangle2D rectangle2D) {
        return rectangle2D;
    }

    public Shape getDataClipRegion(Rectangle2D rectangle2D) {
        return rectangle2D;
    }

    public void drawPlotBackground(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, Shape shape) {
        if (categoryPlot.getBackgroundPaint() != null) {
            graphics2D.setPaint(categoryPlot.getBackgroundPaint());
            graphics2D.fill(shape);
        }
        if (categoryPlot.getOutlineStroke() != null && categoryPlot.getOutlinePaint() != null) {
            graphics2D.setStroke(categoryPlot.getOutlineStroke());
            graphics2D.setPaint(categoryPlot.getOutlinePaint());
            graphics2D.draw(shape);
        }
    }

    public abstract void drawCategoryItem(Graphics2D var1, Rectangle2D var2, CategoryPlot var3, ValueAxis var4, CategoryDataset var5, int var6, Object var7, int var8, Object var9);

    public abstract void drawRangeMarker(Graphics2D var1, CategoryPlot var2, ValueAxis var3, Marker var4, Rectangle2D var5, Shape var6);
}

