/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.entity.ChartEntity;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.PieSectionEntity;
import com.jrefinery.chart.entity.XYItemEntity;
import com.keypoint.PngEncoder;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;

public class ChartUtilities {
    public static void writeChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2) throws IOException {
        ChartUtilities.writeChartAsPNG(outputStream, jFreeChart, n, n2, null);
    }

    public static void writeChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) throws IOException {
        BufferedImage bufferedImage = jFreeChart.createBufferedImage(n, n2, chartRenderingInfo);
        PngEncoder pngEncoder = new PngEncoder((Image)bufferedImage, false, 0, 9);
        byte[] byArray = pngEncoder.pngEncode();
        outputStream.write(byArray);
    }

    public static void saveChartAsPNG(File file, JFreeChart jFreeChart, int n, int n2) throws IOException {
        ChartUtilities.saveChartAsPNG(file, jFreeChart, n, n2, null);
    }

    public static void saveChartAsPNG(File file, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        ChartUtilities.writeChartAsPNG(bufferedOutputStream, jFreeChart, n, n2, chartRenderingInfo);
        ((OutputStream)bufferedOutputStream).close();
    }

    public static void writeChartAsJPEG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2) throws IOException {
        BufferedImage bufferedImage = jFreeChart.createBufferedImage(n, n2);
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
        JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
        jPEGEncodeParam.setQuality(1.0f, true);
        jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
    }

    public static void saveChartAsJPEG(File file, JFreeChart jFreeChart, int n, int n2) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        ChartUtilities.writeChartAsJPEG(bufferedOutputStream, jFreeChart, n, n2);
        ((OutputStream)bufferedOutputStream).close();
    }

    public static void writeImageMap(PrintWriter printWriter, String string, String string2, ChartRenderingInfo chartRenderingInfo) throws IOException {
        printWriter.println("<MAP NAME=\"" + string + "\">");
        EntityCollection entityCollection = chartRenderingInfo.getEntityCollection();
        Iterator iterator = entityCollection.iterator();
        while (iterator.hasNext()) {
            ChartEntity chartEntity;
            ChartEntity chartEntity2 = (ChartEntity)iterator.next();
            if (chartEntity2 instanceof PieSectionEntity) {
                chartEntity = (PieSectionEntity)chartEntity2;
                printWriter.println(((PieSectionEntity)chartEntity).getImageMapAreaTag(string2));
                continue;
            }
            if (chartEntity2 instanceof CategoryItemEntity) {
                chartEntity = (CategoryItemEntity)chartEntity2;
                printWriter.println(((CategoryItemEntity)chartEntity).getImageMapAreaTag(string2));
                continue;
            }
            if (!(chartEntity2 instanceof XYItemEntity)) continue;
            chartEntity = (XYItemEntity)chartEntity2;
            printWriter.println(((XYItemEntity)chartEntity).getImageMapAreaTag(string2));
        }
        printWriter.println("</MAP>");
    }
}

