/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.BarRenderer;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardCategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Range;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class HorizontalBarRenderer
extends BarRenderer
implements CategoryItemRenderer {
    public HorizontalBarRenderer() {
        this(new StandardCategoryToolTipGenerator());
    }

    public HorizontalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator) {
        super(categoryToolTipGenerator);
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, categoryPlot, valueAxis, categoryDataset, chartRenderingInfo);
        this.calculateCategoryAndItemSpans(graphics2D, rectangle2D, categoryPlot, categoryDataset, rectangle2D.getHeight());
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D, Shape shape) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        graphics2D.setPaint(marker.getOutlinePaint());
        graphics2D.draw(double_);
    }

    public void drawCategoryItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, Object object, int n2, Object object2) {
        Number number = categoryDataset.getValue(n, object);
        if (number != null) {
            Object object3;
            Object object4;
            double d = number.doubleValue();
            double d2 = 0.0;
            if (this.upperClip <= 0.0) {
                if (d >= this.upperClip) {
                    return;
                }
                d2 = this.upperClip;
                if (d <= this.lowerClip) {
                    d = this.lowerClip;
                }
            } else if (this.lowerClip <= 0.0) {
                if (d >= this.upperClip) {
                    d = this.upperClip;
                } else if (d <= this.lowerClip) {
                    d = this.lowerClip;
                }
            } else {
                if (d <= this.lowerClip) {
                    return;
                }
                d2 = this.lowerClip;
                if (d >= this.upperClip) {
                    d = this.upperClip;
                }
            }
            double d3 = valueAxis.translateValueToJava2D(d2, rectangle2D);
            double d4 = valueAxis.translateValueToJava2D(d, rectangle2D);
            double d5 = Math.min(d3, d4);
            double d6 = Math.abs(d4 - d3);
            double d7 = rectangle2D.getY() + rectangle2D.getHeight() * categoryPlot.getIntroGapPercent();
            int n3 = categoryDataset.getCategoryCount();
            int n4 = categoryDataset.getSeriesCount();
            if (n3 > 1) {
                d7 = d7 + (double)n2 * this.categorySpan / (double)n3 + (double)n2 * this.categoryGapSpan / (double)(n3 - 1) + (double)n * this.itemSpan / (double)(n3 * n4);
                if (n4 > 1) {
                    d7 += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
                }
            } else {
                d7 += (double)n * this.itemSpan / (double)(n3 * n4);
                if (n4 > 1) {
                    d7 += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
                }
            }
            double d8 = this.itemWidth;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d7, d6, d8);
            Paint paint = categoryPlot.getSeriesPaint(n);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (this.itemWidth > 3.0) {
                graphics2D.setStroke(categoryPlot.getSeriesStroke(n));
                graphics2D.setPaint(categoryPlot.getSeriesOutlinePaint(n));
                graphics2D.draw(double_);
                if (categoryPlot.getLabelsVisible()) {
                    object4 = categoryPlot.getLabelFont();
                    graphics2D.setFont((Font)object4);
                    object3 = categoryPlot.getLabelPaint();
                    graphics2D.setPaint((Paint)object3);
                    graphics2D.drawString(String.valueOf(number), (int)(d5 + d6 * 0.9), (int)d7 - 5);
                }
            }
            if (this.info != null && (object4 = this.info.getEntityCollection()) != null) {
                object3 = "";
                if (this.toolTipGenerator != null) {
                    object3 = this.toolTipGenerator.generateToolTip(categoryDataset, n, object);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, (String)object3, n, object, n2);
                object4.addEntity(categoryItemEntity);
            }
        }
    }

    public boolean hasItemGaps() {
        return true;
    }

    public int barWidthsPerCategory(CategoryDataset categoryDataset) {
        return categoryDataset.getSeriesCount();
    }
}

