/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalBarRenderer;
import com.jrefinery.chart.HorizontalNumberAxis3D;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardCategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Range;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class HorizontalBarRenderer3D
extends HorizontalBarRenderer {
    private static final double DEFAULT_EFFECT3D = 10.0;
    protected double effect3d;

    public HorizontalBarRenderer3D() {
        this(new StandardCategoryToolTipGenerator(), 10.0);
    }

    public HorizontalBarRenderer3D(CategoryToolTipGenerator categoryToolTipGenerator, double d) {
        super(categoryToolTipGenerator);
        this.effect3d = d;
    }

    public boolean hasItemGaps() {
        return true;
    }

    public int barWidthsPerCategory(CategoryDataset categoryDataset) {
        return categoryDataset.getSeriesCount();
    }

    public Rectangle2D getAxisArea(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.effect3d, rectangle2D.getWidth() - this.effect3d, rectangle2D.getHeight() - this.effect3d);
    }

    public Shape getDataClipRegion(Rectangle2D rectangle2D) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)rectangle2D.getX(), (float)(rectangle2D.getMinY() + this.effect3d));
        generalPath.lineTo((float)(rectangle2D.getX() + this.effect3d), (float)rectangle2D.getMinY());
        generalPath.lineTo((float)rectangle2D.getMaxX(), (float)rectangle2D.getMinY());
        generalPath.lineTo((float)rectangle2D.getMaxX(), (float)(rectangle2D.getMaxY() - this.effect3d));
        generalPath.lineTo((float)(rectangle2D.getMaxX() - this.effect3d), (float)rectangle2D.getMaxY());
        generalPath.lineTo((float)rectangle2D.getX(), (float)rectangle2D.getMaxY());
        generalPath.closePath();
        return generalPath;
    }

    public void drawPlotBackground(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, Shape shape) {
        super.drawPlotBackground(graphics2D, categoryPlot, rectangle2D, shape);
        double d = rectangle2D.getX();
        double d2 = d + this.effect3d;
        double d3 = rectangle2D.getMaxX() + this.effect3d;
        double d4 = rectangle2D.getMaxY();
        double d5 = d4 - this.effect3d;
        double d6 = rectangle2D.getMinY() - this.effect3d;
        graphics2D.setPaint(categoryPlot.getOutlinePaint());
        Line2D.Double double_ = new Line2D.Double(d, d4, d2, d5);
        graphics2D.draw(double_);
        ((Line2D)double_).setLine(d2, d5, d2, d6);
        graphics2D.draw(double_);
        ((Line2D)double_).setLine(d2, d5, d3, d5);
        graphics2D.draw(double_);
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D, Shape shape) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        float f = (float)valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        float f2 = (float)rectangle2D.getMaxY();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo((float)((double)f + this.effect3d), f2 - (float)this.effect3d);
        generalPath.lineTo((float)((double)f + this.effect3d), (float)(rectangle2D.getMinY() - this.effect3d));
        generalPath.lineTo(f, (float)rectangle2D.getMinY());
        generalPath.closePath();
        graphics2D.setPaint(marker.getPaint());
        graphics2D.fill(generalPath);
        graphics2D.setPaint(marker.getOutlinePaint());
        graphics2D.draw(generalPath);
    }

    public void drawCategoryItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, Object object, int n2, Object object2) {
        Number number = categoryDataset.getValue(n, object);
        if (number != null) {
            double d = number.doubleValue();
            double d2 = 0.0;
            if (this.upperClip <= 0.0) {
                if (d >= this.upperClip) {
                    return;
                }
                d2 = this.upperClip;
                if (d <= this.lowerClip) {
                    d = this.lowerClip;
                }
            } else if (this.lowerClip <= 0.0) {
                if (d >= this.upperClip) {
                    d = this.upperClip;
                } else if (d <= this.lowerClip) {
                    d = this.lowerClip;
                }
            } else {
                if (d <= this.lowerClip) {
                    return;
                }
                d2 = this.lowerClip;
                if (d >= this.upperClip) {
                    d = this.upperClip;
                }
            }
            double d3 = valueAxis.translateValueToJava2D(d2, rectangle2D);
            double d4 = valueAxis.translateValueToJava2D(d, rectangle2D);
            double d5 = Math.min(d3, d4);
            double d6 = Math.abs(d4 - d3);
            double d7 = rectangle2D.getY() + rectangle2D.getHeight() * categoryPlot.getIntroGapPercent();
            int n3 = categoryDataset.getCategoryCount();
            int n4 = categoryDataset.getSeriesCount();
            if (n3 > 1) {
                d7 = d7 + (double)n2 * this.categorySpan / (double)n3 + (double)n2 * this.categoryGapSpan / (double)(n3 - 1) + (double)n * this.itemSpan / (double)(n3 * n4);
                if (n4 > 1) {
                    d7 += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
                }
            } else {
                d7 += (double)n * this.itemSpan / (double)(n3 * n4);
                if (n4 > 1) {
                    d7 += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
                }
            }
            double d8 = this.itemWidth;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d7, d6, d8);
            Paint paint = categoryPlot.getSeriesPaint(n);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            GeneralPath generalPath = null;
            GeneralPath generalPath2 = null;
            double d9 = 0.0;
            HorizontalAxis horizontalAxis = (HorizontalAxis)((Object)categoryPlot.getRangeAxis());
            if (d6 != 0.0 && horizontalAxis instanceof HorizontalNumberAxis3D) {
                d9 = ((HorizontalNumberAxis3D)horizontalAxis).getEffect3d();
                generalPath = new GeneralPath();
                generalPath.moveTo((float)(d5 + d6), (float)d7);
                generalPath.lineTo((float)(d5 + d6), (float)(d7 + d8));
                generalPath.lineTo((float)(d5 + d6 + d9), (float)(d7 + d8 - d9));
                generalPath.lineTo((float)(d5 + d6 + d9), (float)(d7 - d9));
                if (paint instanceof Color) {
                    graphics2D.setPaint((Color)paint);
                }
                graphics2D.fill(generalPath);
                generalPath2 = new GeneralPath();
                generalPath2.moveTo((float)d5, (float)d7);
                generalPath2.lineTo((float)(d5 + d9), (float)(d7 - d9));
                generalPath2.lineTo((float)(d5 + d6 + d9), (float)(d7 - d9));
                generalPath2.lineTo((float)(d5 + d6), (float)d7);
                if (paint instanceof Color) {
                    graphics2D.setPaint(((Color)paint).darker());
                }
                graphics2D.fill(generalPath2);
            }
            if (this.itemWidth > 3.0) {
                graphics2D.setStroke(categoryPlot.getSeriesStroke(n));
                graphics2D.setPaint(categoryPlot.getSeriesOutlinePaint(n));
                graphics2D.draw(double_);
                if (generalPath != null) {
                    graphics2D.draw(generalPath);
                }
                if (generalPath2 != null) {
                    graphics2D.draw(generalPath2);
                }
                if (categoryPlot.getLabelsVisible()) {
                    Font font = categoryPlot.getLabelFont();
                    graphics2D.setFont(font);
                    Paint paint2 = categoryPlot.getLabelPaint();
                    graphics2D.setPaint(paint2);
                    graphics2D.drawString(String.valueOf(number), (int)(d5 + d6 * 0.9), (int)d7 - 15);
                }
            }
        }
    }
}

