/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractTitle;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.JFreeChartInfo;
import com.jrefinery.chart.Legend;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.TextTitle;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.event.ChartChangeEvent;
import com.jrefinery.chart.event.ChartChangeListener;
import com.jrefinery.chart.event.LegendChangeEvent;
import com.jrefinery.chart.event.LegendChangeListener;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.chart.event.PlotChangeListener;
import com.jrefinery.chart.event.TitleChangeEvent;
import com.jrefinery.chart.event.TitleChangeListener;
import com.jrefinery.ui.Drawable;
import com.jrefinery.ui.about.ProjectInfo;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JFreeChart
implements JFreeChartConstants,
Drawable,
TitleChangeListener,
LegendChangeListener,
PlotChangeListener {
    public static final ProjectInfo INFO = new JFreeChartInfo();
    protected List titles;
    protected Legend legend;
    protected Plot plot;
    protected boolean antialias;
    protected Paint backgroundPaint;
    protected Image backgroundImage;
    protected float backgroundImageAlpha = 0.5f;
    protected List listeners;
    private Rectangle2D titleArea = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private Rectangle2D nonTitleArea = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);

    public JFreeChart(Plot plot) {
        this(null, null, plot, false);
    }

    public JFreeChart(String string, Font font, Plot plot, boolean bl) {
        this.listeners = new ArrayList();
        this.plot = plot;
        plot.addChangeListener(this);
        this.titles = new ArrayList();
        if (bl) {
            this.legend = Legend.createInstance(this);
            this.legend.addChangeListener(this);
        }
        this.antialias = true;
        this.backgroundPaint = JFreeChartConstants.DEFAULT_BACKGROUND_PAINT;
        if (string != null) {
            if (font == null) {
                font = JFreeChartConstants.DEFAULT_TITLE_FONT;
            }
            TextTitle textTitle = new TextTitle(string, font);
            textTitle.addChangeListener(this);
            this.titles.add(textTitle);
        }
    }

    public List getTitles() {
        return this.titles;
    }

    public void setTitles(List list) {
        this.titles = list;
        this.fireChartChanged();
    }

    public int getTitleCount() {
        return this.titles.size();
    }

    public AbstractTitle getTitle(int n) {
        if (n < 0 || n == this.getTitleCount()) {
            throw new IllegalArgumentException("JFreeChart.getTitle(...): index out of range.");
        }
        return (AbstractTitle)this.titles.get(n);
    }

    public void addTitle(AbstractTitle abstractTitle) {
        if (abstractTitle != null) {
            this.titles.add(abstractTitle);
            abstractTitle.addChangeListener(this);
            this.fireChartChanged();
        }
    }

    public Legend getLegend() {
        return this.legend;
    }

    public void setLegend(Legend legend) {
        Legend legend2 = this.legend;
        if (legend2 != null) {
            legend2.removeChangeListener(this);
        }
        this.legend = legend;
        if (legend != null) {
            legend.addChangeListener(this);
        }
        this.fireChartChanged();
    }

    public Plot getPlot() {
        return this.plot;
    }

    public CategoryPlot getCategoryPlot() {
        return (CategoryPlot)this.plot;
    }

    public XYPlot getXYPlot() {
        return (XYPlot)this.plot;
    }

    public boolean getAntiAlias() {
        return this.antialias;
    }

    public void setAntiAlias(boolean bl) {
        if (this.antialias != bl) {
            this.antialias = bl;
            this.fireChartChanged();
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (this.backgroundPaint != null) {
            if (!this.backgroundPaint.equals(paint)) {
                this.backgroundPaint = paint;
                this.fireChartChanged();
            }
        } else if (paint != null) {
            this.backgroundPaint = paint;
            this.fireChartChanged();
        }
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image image) {
        if (this.backgroundImage != null) {
            if (!this.backgroundImage.equals(image)) {
                this.backgroundImage = image;
                this.fireChartChanged();
            }
        } else if (image != null) {
            this.backgroundImage = image;
            this.fireChartChanged();
        }
    }

    public float getBackgroundImageAlpha() {
        return this.backgroundImageAlpha;
    }

    public void setBackgroundImageAlpha(float f) {
        if (this.backgroundImageAlpha != f) {
            this.backgroundImageAlpha = f;
            this.fireChartChanged();
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.draw(graphics2D, rectangle2D, null);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Cloneable cloneable;
        Object object;
        if (chartRenderingInfo != null) {
            chartRenderingInfo.clear();
            chartRenderingInfo.setChartArea(rectangle2D);
        }
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        if (this.antialias) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.backgroundPaint != null) {
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D);
        }
        if (this.backgroundImage != null) {
            object = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.backgroundImageAlpha));
            graphics2D.drawImage(this.backgroundImage, (int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), null);
            graphics2D.setComposite((Composite)object);
        }
        this.nonTitleArea.setRect(rectangle2D);
        object = this.titles.iterator();
        while (object.hasNext()) {
            cloneable = (AbstractTitle)object.next();
            switch (((AbstractTitle)cloneable).getPosition()) {
                case 0: {
                    double d = Math.min(((AbstractTitle)cloneable).getPreferredHeight(graphics2D), this.nonTitleArea.getHeight());
                    double d2 = this.nonTitleArea.getWidth();
                    this.titleArea.setRect(this.nonTitleArea.getX(), this.nonTitleArea.getY(), d2, d);
                    ((AbstractTitle)cloneable).draw(graphics2D, this.titleArea);
                    this.nonTitleArea.setRect(this.nonTitleArea.getX(), Math.min(this.nonTitleArea.getY() + d, this.nonTitleArea.getMaxY()), d2, Math.max(this.nonTitleArea.getHeight() - d, 0.0));
                    break;
                }
                case 1: {
                    double d = Math.min(((AbstractTitle)cloneable).getPreferredHeight(graphics2D), this.nonTitleArea.getHeight());
                    double d2 = this.nonTitleArea.getWidth();
                    this.titleArea.setRect(this.nonTitleArea.getX(), this.nonTitleArea.getMaxY() - d, d2, d);
                    ((AbstractTitle)cloneable).draw(graphics2D, this.titleArea);
                    this.nonTitleArea.setRect(this.nonTitleArea.getX(), this.nonTitleArea.getY(), d2, this.nonTitleArea.getHeight() - d);
                    break;
                }
                case 2: {
                    double d = this.nonTitleArea.getHeight();
                    double d2 = Math.min(((AbstractTitle)cloneable).getPreferredWidth(graphics2D), this.nonTitleArea.getWidth());
                    this.titleArea.setRect(this.nonTitleArea.getMaxX() - d2, this.nonTitleArea.getY(), d2, d);
                    ((AbstractTitle)cloneable).draw(graphics2D, this.titleArea);
                    this.nonTitleArea.setRect(this.nonTitleArea.getX(), this.nonTitleArea.getY(), this.nonTitleArea.getWidth() - d2, d);
                    break;
                }
                case 3: {
                    double d = this.nonTitleArea.getHeight();
                    double d2 = Math.min(((AbstractTitle)cloneable).getPreferredWidth(graphics2D), this.nonTitleArea.getWidth());
                    this.titleArea.setRect(this.nonTitleArea.getX(), this.nonTitleArea.getY(), d2, d);
                    ((AbstractTitle)cloneable).draw(graphics2D, this.titleArea);
                    this.nonTitleArea.setRect(this.nonTitleArea.getX() + d2, this.nonTitleArea.getY(), this.nonTitleArea.getWidth() - d2, d);
                    break;
                }
                default: {
                    throw new RuntimeException("JFreeChart.draw(...): unknown title position.");
                }
            }
        }
        cloneable = this.nonTitleArea;
        if (this.legend != null) {
            ((Rectangle2D)cloneable).setRect(this.legend.draw(graphics2D, this.nonTitleArea));
        }
        this.plot.draw(graphics2D, (Rectangle2D)cloneable, chartRenderingInfo);
        graphics2D.setClip(shape);
    }

    public BufferedImage createBufferedImage(int n, int n2) {
        return this.createBufferedImage(n, n2, null);
    }

    public BufferedImage createBufferedImage(int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, n, n2), chartRenderingInfo);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void handleClick(int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        this.plot.handleClick(n, n2, chartRenderingInfo);
    }

    public void addChangeListener(ChartChangeListener chartChangeListener) {
        this.listeners.add(chartChangeListener);
    }

    public void removeChangeListener(ChartChangeListener chartChangeListener) {
        this.listeners.remove(chartChangeListener);
    }

    protected void fireChartChanged() {
        ChartChangeEvent chartChangeEvent = new ChartChangeEvent(this);
        this.notifyListeners(chartChangeEvent);
    }

    protected void notifyListeners(ChartChangeEvent chartChangeEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ChartChangeListener chartChangeListener = (ChartChangeListener)iterator.next();
            chartChangeListener.chartChanged(chartChangeEvent);
        }
    }

    public void titleChanged(TitleChangeEvent titleChangeEvent) {
        titleChangeEvent.setChart(this);
        this.notifyListeners(titleChangeEvent);
    }

    public void legendChanged(LegendChangeEvent legendChangeEvent) {
        legendChangeEvent.setChart(this);
        this.notifyListeners(legendChangeEvent);
    }

    public void plotChanged(PlotChangeEvent plotChangeEvent) {
        plotChangeEvent.setChart(this);
        this.notifyListeners(plotChangeEvent);
    }

    public static void main(String[] stringArray) {
        System.out.println(INFO.toString());
    }
}

