/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.PiePlot;
import com.jrefinery.chart.entity.PieSectionEntity;
import com.jrefinery.chart.tooltips.StandardPieToolTipGenerator;
import com.jrefinery.data.PieDataset;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Pie3DPlot
extends PiePlot {
    protected double depthFactor = 0.2;

    public Pie3DPlot(PieDataset pieDataset) throws AxisNotCompatibleException {
        super(pieDataset);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Paint paint;
        Cloneable cloneable;
        Object object;
        List list;
        Rectangle2D rectangle2D2;
        Shape shape = graphics2D.getClip();
        Rectangle2D rectangle2D3 = rectangle2D2 = shape != null ? shape.getBounds2D().createIntersection(rectangle2D) : rectangle2D;
        if (this.insets != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)this.insets.left, rectangle2D.getY() + (double)this.insets.top, rectangle2D.getWidth() - (double)this.insets.left - (double)this.insets.right, rectangle2D.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
            chartRenderingInfo.setDataArea(rectangle2D);
        }
        double d = rectangle2D.getWidth() * this.interiorGapPercent;
        double d2 = rectangle2D.getHeight() * this.interiorGapPercent;
        double d3 = rectangle2D.getX() + d / 2.0;
        double d4 = rectangle2D.getY() + d2 / 2.0;
        double d5 = rectangle2D.getWidth() - d;
        double d6 = rectangle2D.getHeight() - d2;
        if (this.circular) {
            double d7 = Math.min(d5, d6) / 2.0;
            d3 = (d3 + d3 + d5) / 2.0 - d7;
            d4 = (d4 + d4 + d6) / 2.0 - d7;
            d5 = 2.0 * d7;
            d6 = 2.0 * d7;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, d5, d6);
        double d8 = (1.0 - this.radiusPercent) * d5;
        double d9 = (1.0 - this.radiusPercent) * d6;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d3 + d8 / 2.0, d4 + d9 / 2.0, d5 - d8, d6 - d9);
        this.drawOutlineAndBackground(graphics2D, rectangle2D);
        PieDataset pieDataset = this.getPieDataset();
        if (pieDataset == null) {
            return;
        }
        if ((double)pieDataset.getCategories().size() > rectangle2D.getWidth()) {
            String string = "Too many elements";
            Font font = new Font("dialog", 1, 10);
            graphics2D.setFont(font);
            int n = (int)font.getStringBounds(string, graphics2D.getFontRenderContext()).getWidth();
            graphics2D.drawString(string, (int)(rectangle2D.getX() + (rectangle2D.getWidth() - (double)n) / 2.0), (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0));
            return;
        }
        if (this.circular) {
            double d10 = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight()) / 2.0;
            rectangle2D = new Rectangle2D.Double(rectangle2D.getCenterX() - d10, rectangle2D.getCenterY() - d10, 2.0 * d10, 2.0 * d10);
        }
        if ((list = pieDataset.getCategories()).size() == 0) {
            return;
        }
        double d11 = ((RectangularShape)double_2).getX();
        double d12 = ((RectangularShape)double_2).getY();
        graphics2D.clip(rectangle2D2);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.foregroundAlpha));
        double d13 = 0.0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Number number;
            double d14;
            Object e = iterator.next();
            if (e == null || !((d14 = (number = pieDataset.getValue(e)).doubleValue()) > 0.0)) continue;
            d13 += d14;
        }
        double d15 = 0.0;
        int n = (int)(((RectangularShape)double_2).getHeight() * this.depthFactor);
        if (n < 0) {
            return;
        }
        ArrayList<Arc2D.Double> arrayList = new ArrayList<Arc2D.Double>();
        boolean bl = false;
        iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            object = pieDataset.getValue(e);
            double d16 = ((Number)object).doubleValue();
            if (d16 <= 0.0) {
                arrayList.add(null);
                continue;
            }
            bl = true;
            double d17 = d15 * 360.0 / d13;
            double d18 = (d15 + d16) * 360.0 / d13 - d17;
            arrayList.add(new Arc2D.Double(d11, d12 + (double)n, ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n, d17, d18, 2));
            d15 += d16;
        }
        object = graphics2D.getClip();
        Paint paint2 = this.getSeriesOutlinePaint(0);
        Arc2D.Double double_3 = new Arc2D.Double(d11, d12 + (double)n, ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n, 0.0, 360.0, 2);
        graphics2D.setPaint(paint2);
        if (bl) {
            graphics2D.drawLine((int)double_3.getMaxX(), (int)double_3.getCenterY(), (int)double_3.getMaxX(), (int)(double_3.getCenterY() - (double)n));
        }
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            double_3 = (Arc2D.Double)arrayList.get(n3);
            if (double_3 != null && !(double_3.getAngleStart() + double_3.getAngleExtent() < 180.0)) {
                Point2D point2D = double_3.getAngleStart() > 180.0 ? double_3.getStartPoint() : new Point2D.Double(double_3.getMinX(), double_3.getCenterY());
                cloneable = double_3.getEndPoint();
                paint = this.getSeriesPaint(n3);
                paint2 = this.getSeriesOutlinePaint(n3);
                graphics2D.setClip(object.getBounds2D().createIntersection(new Rectangle2D.Double(Math.min(((Point2D)cloneable).getX(), point2D.getX()), double_3.getMinY(), Math.abs(((Point2D)cloneable).getX() - point2D.getX()), double_3.getHeight() + 3.0)));
                graphics2D.setPaint(paint);
                graphics2D.fill(double_3);
                graphics2D.draw(double_3);
                graphics2D.setPaint(paint2);
                double_3.setArcType(0);
                graphics2D.draw(double_3);
                double_3.setArcType(2);
                graphics2D.setPaint(paint);
                int[] nArray = new int[]{(int)point2D.getX(), (int)((Point2D)cloneable).getX(), (int)((Point2D)cloneable).getX(), (int)point2D.getX()};
                int[] nArray2 = new int[]{(int)point2D.getY(), (int)((Point2D)cloneable).getY(), (int)((Point2D)cloneable).getY() - n, (int)point2D.getY() - n};
                Polygon polygon = new Polygon(nArray, nArray2, 4);
                graphics2D.fill(polygon);
                graphics2D.setPaint(paint2);
                graphics2D.drawLine((int)point2D.getX(), (int)point2D.getY(), (int)point2D.getX(), (int)point2D.getY() - n);
            }
            ++n3;
        }
        graphics2D.setClip((Shape)object);
        cloneable = new Rectangle2D.Double(((RectangularShape)double_2).getX(), ((RectangularShape)double_2).getY(), ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n);
        int n4 = 0;
        while (n4 < n2) {
            double_3 = (Arc2D.Double)arrayList.get(n4);
            if (double_3 != null) {
                Arc2D.Double double_4 = new Arc2D.Double(d11, d12, ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n, double_3.getAngleStart(), double_3.getAngleExtent(), 2);
                paint = this.getSeriesPaint(n4);
                paint2 = this.getSeriesOutlinePaint(n4);
                graphics2D.setPaint(paint);
                graphics2D.fill(double_4);
                graphics2D.setStroke(new BasicStroke());
                graphics2D.setPaint(paint2);
                graphics2D.draw(double_4);
                Object e = list.get(n4);
                if (chartRenderingInfo != null) {
                    if (this.toolTipGenerator == null) {
                        this.toolTipGenerator = new StandardPieToolTipGenerator();
                    }
                    String string = this.toolTipGenerator.generateToolTip(pieDataset, e);
                    PieSectionEntity pieSectionEntity = new PieSectionEntity(double_3, string, e, n4);
                    chartRenderingInfo.getEntityCollection().addEntity(pieSectionEntity);
                }
                if (this.sectionLabelType != 0) {
                    this.drawLabel(graphics2D, (Rectangle2D)cloneable, double_, pieDataset, pieDataset.getValue(e).doubleValue(), n4, double_3.getAngleStart(), double_3.getAngleExtent());
                }
            }
            ++n4;
        }
        graphics2D.clip(shape);
        graphics2D.setComposite(composite);
    }

    public String getPlotType() {
        return "Pie 3D Plot";
    }

    public void setDepthFactor(double d) {
        this.depthFactor = d;
    }

    public double getDepthFactor() {
        return this.depthFactor;
    }
}

