/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.entity.PieSectionEntity;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.chart.tooltips.PieToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardPieToolTipGenerator;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.PieDataset;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PiePlot
extends Plot {
    public static final int CLOCKWISE = -1;
    public static final int ANTICLOCKWISE = 1;
    public static final double DEFAULT_INTERIOR_GAP = 0.2;
    public static final double MAX_INTERIOR_GAP = 0.4;
    public static final double DEFAULT_RADIUS = 1.0;
    public static final double MAX_RADIUS = 1.0;
    public static final Font DEFAULT_SECTION_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_SECTION_LABEL_PAINT = Color.black;
    public static final double DEFAULT_SECTION_LABEL_GAP = 0.1;
    public static final double MAX_SECTION_LABEL_GAP = 0.3;
    public static final int NO_LABELS = 0;
    public static final int NAME_LABELS = 1;
    public static final int VALUE_LABELS = 2;
    public static final int PERCENT_LABELS = 3;
    public static final int NAME_AND_VALUE_LABELS = 4;
    public static final int NAME_AND_PERCENT_LABELS = 5;
    public static final int VALUE_AND_PERCENT_LABELS = 6;
    protected double interiorGapPercent;
    protected boolean circular;
    protected int direction = -1;
    protected double startAngle = 90.0;
    protected double radiusPercent;
    protected int sectionLabelType;
    protected Font sectionLabelFont;
    protected Paint sectionLabelPaint;
    protected double sectionLabelGapPercent;
    protected double[] explodePercentages;
    protected DecimalFormat valueFormatter;
    protected DecimalFormat percentFormatter;
    protected PieToolTipGenerator toolTipGenerator;

    public PiePlot(PieDataset pieDataset) {
        this(pieDataset, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, 0.2, true, 1.0, 1, DEFAULT_SECTION_LABEL_FONT, DEFAULT_SECTION_LABEL_PAINT, 0.1, "0.00", "0.0", null);
    }

    public PiePlot(PieDataset pieDataset, Insets insets, Paint paint, Image image, float f, Stroke stroke, Paint paint2, float f2, double d, boolean bl, double d2, int n, Font font, Paint paint3, double d3, String string, String string2, PieToolTipGenerator pieToolTipGenerator) {
        super((Dataset)pieDataset, insets, paint, image, f, stroke, paint2, f2);
        this.interiorGapPercent = d;
        this.circular = bl;
        this.radiusPercent = d2;
        this.sectionLabelType = n;
        this.sectionLabelFont = font;
        this.sectionLabelPaint = paint3;
        this.sectionLabelGapPercent = d3;
        this.valueFormatter = new DecimalFormat(string);
        this.percentFormatter = new DecimalFormat(string2);
        this.explodePercentages = null;
        this.toolTipGenerator = pieToolTipGenerator;
        this.setInsets(insets);
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d) {
        this.startAngle = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n) {
        if (n != -1 && n != 1) {
            throw new IllegalArgumentException("PiePlot.setDirection(int): invalid direction.");
        }
        this.direction = n;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getInteriorGapPercent() {
        return this.interiorGapPercent;
    }

    public void setInteriorGapPercent(double d) {
        if (d < 0.0 || d > 0.4) {
            throw new IllegalArgumentException("PiePlot.setInteriorGapPercent(double): percentage outside valid range.");
        }
        if (this.interiorGapPercent != d) {
            this.interiorGapPercent = d;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean bl) {
        if (this.circular != bl) {
            this.circular = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getRadiusPercent() {
        return this.radiusPercent;
    }

    public void setRadiusPercent(double d) {
        if (d <= 0.0 || d > 1.0) {
            throw new IllegalArgumentException("PiePlot.setRadiusPercent(double): percentage outside valid range.");
        }
        if (this.radiusPercent != d) {
            this.radiusPercent = d;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public int getSectionLabelType() {
        return this.sectionLabelType;
    }

    public void setSectionLabelType(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4 && n != 5 && n != 6) {
            throw new IllegalArgumentException("PiePlot.setSectionLabelType(int): unrecognised type.");
        }
        if (this.sectionLabelType != n) {
            this.sectionLabelType = n;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getSectionLabelFont() {
        return this.sectionLabelFont;
    }

    public void setSectionLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("PiePlot.setSectionLabelFont(...): null font not allowed.");
        }
        if (!this.sectionLabelFont.equals(font)) {
            this.sectionLabelFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getSectionLabelPaint() {
        return this.sectionLabelPaint;
    }

    public void setSectionLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("PiePlot.setSectionLabelPaint(...): null paint not allowed.");
        }
        if (!this.sectionLabelPaint.equals(paint)) {
            this.sectionLabelPaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getSectionLabelGapPercent() {
        return this.sectionLabelGapPercent;
    }

    public void setSectionLabelGapPercent(double d) {
        if (d < 0.0 || d > 0.3) {
            throw new IllegalArgumentException("PiePlot.setSectionLabelGapPercent(double): percentage outside valid range.");
        }
        if (this.sectionLabelGapPercent != d) {
            this.sectionLabelGapPercent = d;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setValueFormatString(String string) {
        this.valueFormatter = new DecimalFormat(string);
    }

    public void setPercentFormatString(String string) {
        this.percentFormatter = new DecimalFormat(string);
    }

    public double getExplodePercent(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("PiePlot.getExplodePercent(int): section outside valid range.");
        }
        double d = 0.0;
        if (this.explodePercentages != null && n < this.explodePercentages.length) {
            d = this.explodePercentages[n];
        }
        return d;
    }

    public void setExplodePercent(int n, double d) {
        if (n < 0 || n >= this.getPieDataset().getCategories().size()) {
            throw new IllegalArgumentException("PiePlot.setExplodePercent(int, double): section outside valid range.");
        }
        if (this.explodePercentages != null) {
            if (n < this.explodePercentages.length) {
                this.explodePercentages[n] = d;
            } else {
                double[] dArray = new double[n];
                int n2 = 0;
                while (n2 < this.explodePercentages.length) {
                    dArray[n2] = this.explodePercentages[n2];
                    ++n2;
                }
                this.explodePercentages = dArray;
                this.explodePercentages[n] = d;
            }
        } else {
            this.explodePercentages = new double[this.getPieDataset().getCategories().size()];
            this.explodePercentages[n] = d;
        }
    }

    public PieDataset getPieDataset() {
        return (PieDataset)this.dataset;
    }

    public Collection getCategories() {
        return this.getPieDataset().getCategories();
    }

    public List getLegendItemLabels() {
        ArrayList<String> arrayList = new ArrayList<String>();
        PieDataset pieDataset = this.getPieDataset();
        List list = pieDataset.getCategories();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().toString());
        }
        return arrayList;
    }

    public PieToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(PieToolTipGenerator pieToolTipGenerator) {
        this.toolTipGenerator = pieToolTipGenerator;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        if (this.insets != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)this.insets.left, rectangle2D.getY() + (double)this.insets.top, rectangle2D.getWidth() - (double)this.insets.left - (double)this.insets.right, rectangle2D.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
            chartRenderingInfo.setDataArea(rectangle2D);
        }
        this.drawOutlineAndBackground(graphics2D, rectangle2D);
        double d = rectangle2D.getWidth() * this.interiorGapPercent;
        double d2 = rectangle2D.getHeight() * this.interiorGapPercent;
        double d3 = rectangle2D.getX() + d / 2.0;
        double d4 = rectangle2D.getY() + d2 / 2.0;
        double d5 = rectangle2D.getWidth() - d;
        double d6 = rectangle2D.getHeight() - d2;
        if (this.circular) {
            double d7 = Math.min(d5, d6) / 2.0;
            d3 = (d3 + d3 + d5) / 2.0 - d7;
            d4 = (d4 + d4 + d6) / 2.0 - d7;
            d5 = 2.0 * d7;
            d6 = 2.0 * d7;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, d5, d6);
        double d8 = (1.0 - this.radiusPercent) * d5;
        double d9 = (1.0 - this.radiusPercent) * d6;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d3 + d8 / 2.0, d4 + d9 / 2.0, d5 - d8, d6 - d9);
        PieDataset pieDataset = this.getPieDataset();
        if (pieDataset != null) {
            Shape shape = graphics2D.getClip();
            graphics2D.clip(rectangle2D);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.foregroundAlpha));
            List list = pieDataset.getCategories();
            double d10 = 0.0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Number number;
                double d11;
                Object e = iterator.next();
                if (e == null || !((d11 = (number = pieDataset.getValue(e)).doubleValue()) > 0.0)) continue;
                d10 += d11;
            }
            double d12 = 0.0;
            int n = 0;
            iterator = list.iterator();
            while (iterator.hasNext()) {
                double d13;
                Object e = iterator.next();
                Number number = pieDataset.getValue(e);
                if (number != null && (d13 = number.doubleValue()) > 0.0) {
                    double d14 = this.startAngle + (double)this.direction * (d12 * 360.0) / d10;
                    double d15 = this.startAngle + (double)this.direction * (d12 + d13) * 360.0 / d10;
                    Rectangle2D rectangle2D2 = this.getArcBounds(double_2, double_, d14, d15 - d14, this.getExplodePercent(n));
                    Arc2D.Double double_3 = new Arc2D.Double(rectangle2D2, d14, d15 - d14, 2);
                    d12 += d13;
                    Paint paint = this.getSeriesPaint(n);
                    Paint paint2 = this.getSeriesOutlinePaint(n);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(double_3);
                    graphics2D.setStroke(new BasicStroke());
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(double_3);
                    if (chartRenderingInfo != null) {
                        if (this.toolTipGenerator == null) {
                            this.toolTipGenerator = new StandardPieToolTipGenerator();
                        }
                        String string = this.toolTipGenerator.generateToolTip(pieDataset, e);
                        PieSectionEntity pieSectionEntity = new PieSectionEntity(double_3, string, e, n);
                        chartRenderingInfo.getEntityCollection().addEntity(pieSectionEntity);
                    }
                    if (this.sectionLabelType != 0) {
                        this.drawLabel(graphics2D, double_2, double_, pieDataset, d13, n, d14, d15 - d14);
                    }
                }
                ++n;
            }
            graphics2D.clip(shape);
            graphics2D.setComposite(composite);
        }
    }

    protected void drawLabel(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, PieDataset pieDataset, double d, int n, double d2, double d3) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        List list = this.getLegendItemLabels();
        String string = "";
        if (this.sectionLabelType == 1) {
            string = list.get(n).toString();
        } else if (this.sectionLabelType == 2) {
            string = this.valueFormatter.format(d);
        } else if (this.sectionLabelType == 3) {
            string = this.percentFormatter.format(d3 / 3.6) + "%";
        } else if (this.sectionLabelType == 4) {
            string = list.get(n).toString() + " (" + this.valueFormatter.format(d) + ")";
        } else if (this.sectionLabelType == 5) {
            string = list.get(n).toString() + " (" + this.percentFormatter.format(d3 / 3.6) + "%)";
        } else if (this.sectionLabelType == 6) {
            string = this.valueFormatter.format(d) + " (" + this.percentFormatter.format(d3 / 3.6) + "%)";
        }
        Rectangle2D rectangle2D3 = this.sectionLabelFont.getStringBounds(string, fontRenderContext);
        LineMetrics lineMetrics = this.sectionLabelFont.getLineMetrics(string, fontRenderContext);
        double d4 = lineMetrics.getAscent();
        Point2D point2D = this.calculateLabelLocation(rectangle2D3, d4, rectangle2D, rectangle2D2, d2, d3, this.getExplodePercent(n));
        graphics2D.setPaint(this.sectionLabelPaint);
        graphics2D.setFont(this.sectionLabelFont);
        graphics2D.drawString(string, (float)point2D.getX(), (float)point2D.getY());
    }

    public String getPlotType() {
        return "Pie Plot";
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        return axis == null;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis == null;
    }

    public void zoom(double d) {
    }

    protected Rectangle2D getArcBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d, double d2, double d3) {
        if (d3 == 0.0) {
            return rectangle2D;
        }
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D, d, d2 / 2.0, 0);
        Point2D point2D = double_.getEndPoint();
        Arc2D.Double double_2 = new Arc2D.Double(rectangle2D2, d, d2 / 2.0, 0);
        Point2D point2D2 = double_2.getEndPoint();
        double d4 = (point2D.getX() - point2D2.getX()) * d3;
        double d5 = (point2D.getY() - point2D2.getY()) * d3;
        return new Rectangle2D.Double(rectangle2D.getX() - d4, rectangle2D.getY() - d5, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    protected Point2D calculateLabelLocation(Rectangle2D rectangle2D, double d, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3, double d2, double d3, double d4) {
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D2, d2, d3 / 2.0, 0);
        Point2D point2D = double_.getEndPoint();
        Arc2D.Double double_2 = new Arc2D.Double(rectangle2D3, d2, d3 / 2.0, 0);
        Point2D point2D2 = double_2.getEndPoint();
        double d5 = (point2D.getX() - point2D2.getX()) * d4;
        double d6 = (point2D.getY() - point2D2.getY()) * d4;
        double d7 = point2D.getX() - (d5 -= (point2D.getX() - rectangle2D2.getCenterX()) * this.sectionLabelGapPercent);
        double d8 = point2D.getY() - (d6 -= (point2D.getY() - rectangle2D2.getCenterY()) * this.sectionLabelGapPercent);
        if (d7 <= rectangle2D2.getCenterX()) {
            d7 -= rectangle2D.getWidth();
        }
        if (d8 > rectangle2D2.getCenterY()) {
            d8 += d;
        }
        return new Point2D.Double(d7, d8);
    }
}

