/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.Legend;
import com.jrefinery.chart.LegendItem;
import com.jrefinery.chart.Spacer;
import com.jrefinery.chart.event.LegendChangeEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class StandardLegend
extends Legend {
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 10);
    protected Stroke outlineStroke;
    protected Paint outlinePaint;
    protected Paint backgroundPaint;
    protected Spacer innerGap;
    protected Font itemFont;
    protected Paint itemPaint;
    protected Stroke keyBoxOutlineStroke = new BasicStroke(0.5f);
    protected Paint keyBoxOutlinePaint = Color.lightGray;

    public StandardLegend(JFreeChart jFreeChart) {
        this(jFreeChart, 3, new Spacer(1, 2.0, 2.0, 2.0, 2.0), Color.white, new BasicStroke(), Color.gray, DEFAULT_FONT, Color.black);
    }

    public StandardLegend(JFreeChart jFreeChart, int n, Spacer spacer, Paint paint, Stroke stroke, Paint paint2, Font font, Paint paint3) {
        super(jFreeChart, n);
        this.innerGap = spacer;
        this.backgroundPaint = paint;
        this.outlineStroke = stroke;
        this.outlinePaint = paint2;
        this.itemFont = font;
        this.itemPaint = paint3;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        this.outlineStroke = stroke;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        this.outlinePaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Font getItemFont() {
        return this.itemFont;
    }

    public void setItemFont(Font font) {
        this.itemFont = font;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getItemPaint() {
        return this.itemPaint;
    }

    public void setItemPaint(Paint paint) {
        this.itemPaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Stroke getKeyBoxOutlineStroke() {
        return this.keyBoxOutlineStroke;
    }

    public void setKeyBoxOutlineStroke(Stroke stroke) {
        this.keyBoxOutlineStroke = stroke;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getKeyBoxOutlinePaint() {
        return this.keyBoxOutlinePaint;
    }

    public void setKeyBoxOutlinePaint(Paint paint) {
        this.keyBoxOutlinePaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Rectangle2D draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        return this.draw(graphics2D, rectangle2D, (this._anchor & 1) != 0, (this._anchor & 2) != 0);
    }

    protected Rectangle2D draw(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl, boolean bl2) {
        List list = this.chart.getPlot().getLegendItemLabels();
        if (list != null && list.size() > 0) {
            double d;
            double d2;
            Rectangle2D rectangle2D2 = new Rectangle2D.Double();
            Point2D.Double double_ = new Point2D.Double();
            LegendItem[] legendItemArray = new LegendItem[list.size()];
            graphics2D.setFont(this.itemFont);
            if (bl) {
                d2 = rectangle2D.getX() + (double)this.outerGap;
                d = rectangle2D.getX() + rectangle2D.getWidth() - (double)(2 * this.outerGap) - 1.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                boolean bl3 = true;
                int n = 0;
                while (n < list.size()) {
                    legendItemArray[n] = this.createLegendItem(graphics2D, list.get(n).toString(), d4, d6);
                    if (!bl3 && legendItemArray[n].getX() + legendItemArray[n].getWidth() + d2 > d) {
                        d3 = Math.max(d3, d4);
                        d4 = 0.0;
                        d6 += d5;
                        --n;
                        bl3 = true;
                    } else {
                        d5 = Math.max(d5, legendItemArray[n].getHeight());
                        d4 += legendItemArray[n].getWidth();
                        bl3 = false;
                    }
                    ++n;
                }
                d3 = Math.max(d3, d4);
                rectangle2D2 = new Rectangle2D.Double(0.0, 0.0, d3, d6 += d5);
                double d7 = bl2 ? rectangle2D.getY() + rectangle2D.getHeight() - d6 - (double)this.outerGap : rectangle2D.getY() + (double)this.outerGap;
                double d8 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - d3 / 2.0;
                double_ = new Point2D.Double(d8, d7);
            } else {
                d2 = 0.0;
                d = 0.0;
                graphics2D.setFont(this.itemFont);
                int n = 0;
                while (n < legendItemArray.length) {
                    legendItemArray[n] = this.createLegendItem(graphics2D, list.get(n).toString(), 0.0, d2);
                    d2 += legendItemArray[n].getHeight();
                    d = Math.max(d, legendItemArray[n].getWidth());
                    ++n;
                }
                rectangle2D2 = new Rectangle2D.Float(0.0f, 0.0f, (float)d, (float)d2);
                double d9 = bl2 ? rectangle2D.getMaxX() - d - (double)this.outerGap : rectangle2D.getX() + (double)this.outerGap;
                double d10 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - d2 / 2.0;
                double_ = new Point2D.Double(d9, d10);
            }
            graphics2D.translate(((Point2D)double_).getX(), ((Point2D)double_).getY());
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D2);
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.setStroke(this.outlineStroke);
            graphics2D.draw(rectangle2D2);
            int n = 0;
            while (n < legendItemArray.length) {
                graphics2D.setPaint(this.chart.getPlot().getSeriesPaint(n));
                Shape shape = legendItemArray[n].getMarker();
                graphics2D.fill(shape);
                if (this.outlineKeyBoxes) {
                    graphics2D.setPaint(this.keyBoxOutlinePaint);
                    graphics2D.setStroke(this.keyBoxOutlineStroke);
                    graphics2D.draw(shape);
                }
                graphics2D.setPaint(this.itemPaint);
                graphics2D.drawString(legendItemArray[n].label, (float)legendItemArray[n].labelPosition.getX(), (float)legendItemArray[n].labelPosition.getY());
                ++n;
            }
            graphics2D.translate(-((Point2D)double_).getX(), -((Point2D)double_).getY());
            if (bl) {
                double d11 = bl2 ? rectangle2D.getY() : rectangle2D.getY() + rectangle2D2.getHeight() + (double)this.outerGap;
                return new Rectangle2D.Double(rectangle2D.getX(), d11, rectangle2D.getWidth(), rectangle2D.getHeight() - rectangle2D2.getHeight() - (double)(2 * this.outerGap));
            }
            double d12 = bl2 ? rectangle2D.getX() : rectangle2D.getX() + rectangle2D2.getWidth() + (double)(2 * this.outerGap);
            return new Rectangle2D.Double(d12, rectangle2D.getY(), rectangle2D.getWidth() - rectangle2D2.getWidth() - (double)(2 * this.outerGap), rectangle2D.getHeight());
        }
        return rectangle2D;
    }

    private Rectangle2D getLegendBox(int n, int n2, float f, Rectangle2D rectangle2D) {
        int n3 = 2;
        float f2 = f * 0.7f;
        float f3 = (float)rectangle2D.getX() + (float)n3 + 0.15f * f;
        float f4 = (float)rectangle2D.getY() + (float)n3 + ((float)n + 0.15f) * f;
        return new Rectangle2D.Float(f3, f4, f2, f2);
    }

    private LegendItem createLegendItem(Graphics2D graphics2D, String string, double d, double d2) {
        int n = 2;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        LineMetrics lineMetrics = fontMetrics.getLineMetrics(string, graphics2D);
        float f = lineMetrics.getHeight();
        LegendItem legendItem = new LegendItem(string);
        float f2 = (float)(d + (double)n + (double)(1.15f * f));
        float f3 = (float)(d2 + (double)n + (double)(f - lineMetrics.getLeading() - lineMetrics.getDescent()));
        legendItem.labelPosition = new Point2D.Float(f2, f3);
        float f4 = f * 0.7f;
        f2 = (float)(d + (double)n + (double)(0.15f * f));
        f3 = (float)(d2 + (double)n + (double)(0.15f * f));
        legendItem.setMarker(new Rectangle2D.Float(f2, f3, f4, f4));
        float f5 = (float)(legendItem.labelPosition.getX() - d + fontMetrics.getStringBounds(string, graphics2D).getWidth() + 0.5 * (double)f);
        float f6 = (float)(2 * n) + f;
        legendItem.setBounds(d, d2, f5, f6);
        return legendItem;
    }
}

