/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.entity.ChartEntity;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.XYItemEntity;
import com.jrefinery.chart.tooltips.StandardXYToolTipGenerator;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class StandardXYItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int IMAGES = 4;
    protected boolean plotShapes;
    protected boolean plotLines;
    protected boolean plotImages;
    protected double shapeScale = 6.0;
    protected Line2D line;

    public StandardXYItemRenderer() {
        this(2, new StandardXYToolTipGenerator());
    }

    public StandardXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator) {
        super(xYToolTipGenerator);
        if ((n & 1) != 0) {
            this.plotShapes = true;
        }
        if ((n & 2) != 0) {
            this.plotLines = true;
        }
        if ((n & 4) != 0) {
            this.plotImages = true;
        }
        if (n == 3) {
            this.plotShapes = true;
            this.plotLines = true;
        }
        this.line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public boolean getPlotImages() {
        return this.plotImages;
    }

    protected double getShapeScale(Plot plot, int n, int n2, double d, double d2) {
        return 6.0;
    }

    protected Shape getShape(Plot plot, int n, int n2, double d, double d2, double d3) {
        return plot.getShape(n, n2, d, d2, d3);
    }

    protected Image getImage(Plot plot, int n, int n2, double d, double d2) {
        return null;
    }

    protected Point getImageHotspot(Plot plot, int n, int n2, double d, double d2, Image image) {
        int n3 = image.getHeight(null);
        int n4 = image.getWidth(null);
        return new Point(n4 / 2, n3 / 2);
    }

    protected boolean isShapeFilled(Plot plot, int n, int n2, double d, double d2) {
        return false;
    }

    protected Paint getPaint(Plot plot, int n, int n2, double d, double d2) {
        return null;
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo) {
        Object object = null;
        EntityCollection entityCollection = null;
        if (chartRenderingInfo != null) {
            entityCollection = chartRenderingInfo.getEntityCollection();
        }
        Paint paint = xYPlot.getSeriesPaint(n);
        Stroke stroke = xYPlot.getSeriesStroke(n);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getXValue(n, n2);
        Number number2 = xYDataset.getYValue(n, n2);
        if (number2 != null) {
            Object object2;
            Object object3;
            double d;
            double d2 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
            Paint paint2 = this.getPaint(xYPlot, n, n2, d2, d = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D));
            if (paint2 != null) {
                graphics2D.setPaint(paint2);
            }
            if (this.plotLines && n2 > 0) {
                object3 = xYDataset.getXValue(n, n2 - 1);
                object2 = xYDataset.getYValue(n, n2 - 1);
                if (object2 != null) {
                    double d3 = valueAxis.translateValueToJava2D(((Number)object3).doubleValue(), rectangle2D);
                    double d4 = valueAxis2.translateValueToJava2D(((Number)object2).doubleValue(), rectangle2D);
                    this.line.setLine(d3, d4, d2, d);
                    if (this.line.intersects(rectangle2D)) {
                        graphics2D.draw(this.line);
                    }
                }
            }
            if (this.plotShapes) {
                this.shapeScale = this.getShapeScale(xYPlot, n, n2, d2, d);
                object3 = this.getShape(xYPlot, n, n2, d2, d, this.shapeScale);
                if (this.isShapeFilled(xYPlot, n, n2, d2, d)) {
                    if (object3.intersects(rectangle2D)) {
                        graphics2D.fill((Shape)object3);
                    }
                } else if (object3.intersects(rectangle2D)) {
                    graphics2D.draw((Shape)object3);
                }
                object = object3;
            }
            if (this.plotImages) {
                this.shapeScale = this.getShapeScale(xYPlot, n, n2, d2, d);
                object3 = this.getImage(xYPlot, n, n2, d2, d);
                if (object3 != null) {
                    object2 = this.getImageHotspot(xYPlot, n, n2, d2, d, (Image)object3);
                    graphics2D.drawImage((Image)object3, (int)(d2 - ((Point)object2).getX()), (int)(d - ((Point)object2).getY()), null);
                }
            }
            if (entityCollection != null) {
                if (object == null) {
                    object = new Rectangle2D.Double(d2 - 2.0, d - 2.0, 4.0, 4.0);
                }
                object3 = "";
                if (this.toolTipGenerator != null) {
                    object3 = this.toolTipGenerator.generateToolTip(xYDataset, n, n2);
                }
                object2 = new XYItemEntity((Shape)object, (String)object3, n, n2);
                entityCollection.addEntity((ChartEntity)object2);
            }
            if (valueAxis.isCrosshairLockedOnData()) {
                if (valueAxis2.isCrosshairLockedOnData()) {
                    crosshairInfo.updateCrosshairPoint(number.doubleValue(), number2.doubleValue());
                } else {
                    crosshairInfo.updateCrosshairX(number.doubleValue());
                }
            } else if (valueAxis2.isCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairY(number2.doubleValue());
            }
        }
    }
}

