/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.StandardXYItemRenderer;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DatasetChangeEvent;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.Range;
import com.jrefinery.data.XYDataset;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class XYPlot
extends Plot
implements HorizontalValuePlot,
VerticalValuePlot,
PropertyChangeListener {
    protected XYPlot parent = null;
    protected int weight = 1;
    protected ValueAxis domainAxis;
    protected ValueAxis rangeAxis;
    protected XYItemRenderer renderer;
    protected List verticalLines = null;
    protected List verticalColors = null;
    protected List horizontalLines = null;
    protected List horizontalColors = null;

    public XYPlot(XYDataset xYDataset, ValueAxis valueAxis, ValueAxis valueAxis2) {
        this(xYDataset, valueAxis, valueAxis2, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, new StandardXYItemRenderer());
    }

    public XYPlot(XYDataset xYDataset, ValueAxis valueAxis, ValueAxis valueAxis2, XYItemRenderer xYItemRenderer) {
        this(xYDataset, valueAxis, valueAxis2, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, xYItemRenderer);
    }

    public XYPlot(XYDataset xYDataset, ValueAxis valueAxis, ValueAxis valueAxis2, Insets insets, Paint paint, Image image, float f, Stroke stroke, Paint paint2, float f2, XYItemRenderer xYItemRenderer) {
        super((Dataset)xYDataset, insets, paint, image, f, stroke, paint2, f2);
        this.renderer = xYItemRenderer;
        this.renderer.addPropertyChangeListener(this);
        this.domainAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.rangeAxis = valueAxis2;
        if (valueAxis2 != null) {
            valueAxis2.setPlot(this);
            valueAxis2.addChangeListener(this);
        }
    }

    public boolean isSubplot() {
        return this.parent != null;
    }

    public Plot getParent() {
        return this.parent;
    }

    public void setParent(XYPlot xYPlot) {
        this.parent = xYPlot;
    }

    public int getSeriesCount() {
        int n = 0;
        XYDataset xYDataset = this.getXYDataset();
        if (xYDataset != null) {
            n = xYDataset.getSeriesCount();
        }
        return n;
    }

    public List getLegendItemLabels() {
        ArrayList<String> arrayList = new ArrayList<String>();
        XYDataset xYDataset = this.getXYDataset();
        if (xYDataset != null) {
            int n = xYDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(xYDataset.getSeriesName(n2));
                ++n2;
            }
        }
        return arrayList;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
    }

    public XYItemRenderer getItemRenderer() {
        return this.renderer;
    }

    public void setXYItemRenderer(XYItemRenderer xYItemRenderer) {
        boolean bl = false;
        if (this.renderer != null) {
            if (!this.renderer.equals(xYItemRenderer)) {
                this.renderer.removePropertyChangeListener(this);
                this.renderer = xYItemRenderer;
                bl = true;
            }
        } else if (xYItemRenderer != null) {
            this.renderer = xYItemRenderer;
            bl = true;
        }
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public XYDataset getXYDataset() {
        return (XYDataset)this.dataset;
    }

    public void addVerticalLine(Number number) {
        this.addVerticalLine(number, Color.blue);
    }

    public void addVerticalLine(Number number, Paint paint) {
        if (this.verticalLines == null) {
            this.verticalLines = new ArrayList();
            this.verticalColors = new ArrayList();
        }
        this.verticalColors.add(paint);
        this.verticalLines.add(number);
    }

    public void addHorizontalLine(Number number) {
        this.addHorizontalLine(number, Color.red);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addHorizontalLine(Number number, Paint paint) {
        if (this.horizontalLines == null) {
            this.horizontalLines = new ArrayList();
            this.horizontalColors = new ArrayList();
        }
        this.horizontalColors.add(paint);
        this.horizontalLines.add(number);
    }

    public ValueAxis getDomainAxis() {
        ValueAxis valueAxis = this.domainAxis;
        if (valueAxis == null && this.parent != null) {
            valueAxis = this.parent.getDomainAxis();
        }
        return valueAxis;
    }

    public ValueAxis getRangeAxis() {
        ValueAxis valueAxis = this.rangeAxis;
        if (valueAxis == null && this.parent != null) {
            valueAxis = this.parent.getRangeAxis();
        }
        return valueAxis;
    }

    public boolean isCompatibleDomainAxis(ValueAxis valueAxis) {
        if (valueAxis == null) {
            return true;
        }
        return valueAxis instanceof HorizontalAxis;
    }

    public boolean isCompatibleRangeAxis(ValueAxis valueAxis) {
        if (valueAxis == null) {
            return true;
        }
        return valueAxis instanceof VerticalAxis;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Object object;
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if (this.insets != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)this.insets.left, rectangle2D.getY() + (double)this.insets.top, rectangle2D.getWidth() - (double)this.insets.left - (double)this.insets.right, rectangle2D.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        double d = 0.0;
        if (this.domainAxis != null) {
            HorizontalAxis horizontalAxis = (HorizontalAxis)((Object)this.domainAxis);
            d = horizontalAxis.reserveHeight(graphics2D, this, rectangle2D);
        }
        double d2 = 0.0;
        if (this.rangeAxis != null) {
            object = (VerticalAxis)((Object)this.rangeAxis);
            d2 = object.reserveAxisArea(graphics2D, this, rectangle2D, d).getWidth();
        }
        object = new Rectangle2D.Double(rectangle2D.getX() + d2, rectangle2D.getY(), rectangle2D.getWidth() - d2, rectangle2D.getHeight() - d);
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setDataArea((Rectangle2D)object);
        }
        CrosshairInfo crosshairInfo = new CrosshairInfo();
        crosshairInfo.setCrosshairDistance(Double.POSITIVE_INFINITY);
        crosshairInfo.setAnchorX(this.getDomainAxis().getAnchorValue());
        crosshairInfo.setAnchorY(this.getRangeAxis().getAnchorValue());
        this.drawOutlineAndBackground(graphics2D, (Rectangle2D)object);
        if (this.domainAxis != null) {
            this.domainAxis.draw(graphics2D, rectangle2D, (Rectangle2D)object);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.draw(graphics2D, rectangle2D, (Rectangle2D)object);
        }
        this.render(graphics2D, (Rectangle2D)object, chartRenderingInfo, crosshairInfo);
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, CrosshairInfo crosshairInfo) {
        XYDataset xYDataset = this.getXYDataset();
        if (xYDataset != null) {
            Shape shape = graphics2D.getClip();
            Composite composite = graphics2D.getComposite();
            graphics2D.clip(rectangle2D);
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.foregroundAlpha));
            this.drawVerticalLines(graphics2D, rectangle2D);
            this.drawHorizontalLines(graphics2D, rectangle2D);
            this.renderer.initialise(graphics2D, rectangle2D, this, xYDataset, chartRenderingInfo);
            ValueAxis valueAxis = this.getDomainAxis();
            ValueAxis valueAxis2 = this.getRangeAxis();
            int n = xYDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                int n3 = xYDataset.getItemCount(n2);
                int n4 = 0;
                while (n4 < n3) {
                    this.renderer.drawItem(graphics2D, rectangle2D, chartRenderingInfo, this, valueAxis, valueAxis2, xYDataset, n2, n4, crosshairInfo);
                    ++n4;
                }
                ++n2;
            }
            valueAxis.setCrosshairValue(crosshairInfo.getCrosshairX());
            if (valueAxis.isCrosshairVisible()) {
                this.drawVerticalLine(graphics2D, rectangle2D, valueAxis.getCrosshairValue(), valueAxis.getCrosshairStroke(), valueAxis.getCrosshairPaint());
            }
            valueAxis2.setCrosshairValue(crosshairInfo.getCrosshairY());
            if (valueAxis2.isCrosshairVisible()) {
                this.drawHorizontalLine(graphics2D, rectangle2D, valueAxis2.getCrosshairValue(), valueAxis2.getCrosshairStroke(), valueAxis2.getCrosshairPaint());
            }
            graphics2D.setClip(shape);
            graphics2D.setComposite(composite);
        }
    }

    protected void drawVerticalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getDomainAxis().translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    protected void drawHorizontalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getRangeAxis().translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    protected void drawVerticalLines(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.verticalLines != null) {
            int n = 0;
            while (n < this.verticalLines.size()) {
                graphics2D.setPaint((Paint)this.verticalColors.get(n));
                graphics2D.setStroke(new BasicStroke(1.0f));
                Number number = (Number)this.verticalLines.get(n);
                int n2 = (int)this.getDomainAxis().translateValueToJava2D(number.doubleValue(), rectangle2D);
                graphics2D.drawLine(n2, (int)rectangle2D.getMinY(), n2, (int)rectangle2D.getMaxY());
                ++n;
            }
        }
    }

    protected void drawHorizontalLines(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.horizontalLines != null) {
            int n = 0;
            while (n < this.horizontalLines.size()) {
                graphics2D.setPaint((Paint)this.horizontalColors.get(n));
                graphics2D.setStroke(new BasicStroke(1.0f));
                Number number = (Number)this.horizontalLines.get(n);
                int n2 = (int)this.getRangeAxis().translateValueToJava2D(number.doubleValue(), rectangle2D);
                graphics2D.drawLine((int)rectangle2D.getMinX(), n2, (int)rectangle2D.getMaxX(), n2);
                ++n;
            }
        }
    }

    public void handleClick(int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        ValueAxis valueAxis = this.getDomainAxis();
        double d = valueAxis.translateJava2DtoValue(n, chartRenderingInfo.getDataArea());
        valueAxis.setAnchorValue(d);
        valueAxis.setCrosshairValue(d);
        ValueAxis valueAxis2 = this.getRangeAxis();
        double d2 = valueAxis2.translateJava2DtoValue(n2, chartRenderingInfo.getDataArea());
        valueAxis2.setAnchorValue(d2);
        valueAxis2.setCrosshairValue(d2);
    }

    public void zoom(double d) {
        if (d > 0.0) {
            ValueAxis valueAxis = this.getDomainAxis();
            double d2 = valueAxis.getMaximumAxisValue() - valueAxis.getMinimumAxisValue();
            double d3 = d2 * d;
            valueAxis.setAnchoredRange(d3);
            ValueAxis valueAxis2 = this.getRangeAxis();
            d2 = valueAxis2.getMaximumAxisValue() - valueAxis2.getMinimumAxisValue();
            d3 = d2 * d;
            valueAxis2.setAnchoredRange(d3);
        } else {
            this.getRangeAxis().setAutoRange(true);
            this.getDomainAxis().setAutoRange(true);
        }
    }

    public String getPlotType() {
        return "XY Plot";
    }

    public Range getHorizontalDataRange() {
        Range range = null;
        if (this.dataset != null) {
            range = DatasetUtilities.getDomainExtent((Dataset)this.dataset);
        }
        return range;
    }

    public Range getVerticalDataRange() {
        Range range = null;
        if (this.dataset != null) {
            range = DatasetUtilities.getRangeExtent((Dataset)this.dataset);
        }
        return range;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        if (this.domainAxis != null) {
            this.domainAxis.configure();
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.configure();
        }
        if (this.parent != null) {
            this.parent.datasetChanged(datasetChangeEvent);
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            this.notifyListeners(plotChangeEvent);
        }
    }

    public HorizontalAxis getHorizontalAxis() {
        return (HorizontalAxis)((Object)this.getDomainAxis());
    }

    public ValueAxis getHorizontalValueAxis() {
        return this.getDomainAxis();
    }

    public VerticalAxis getVerticalAxis() {
        return (VerticalAxis)((Object)this.getRangeAxis());
    }

    public ValueAxis getVerticalValueAxis() {
        return this.getRangeAxis();
    }

    public void setDomainAxis(ValueAxis valueAxis) throws AxisNotCompatibleException {
        if (this.isCompatibleDomainAxis(valueAxis)) {
            if (valueAxis != null) {
                try {
                    valueAxis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("Plot.setDomainAxis(...): plot not compatible with axis.");
                }
                valueAxis.addChangeListener(this);
            }
            if (this.domainAxis != null) {
                this.domainAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setDomainAxis(...): axis not compatible with plot.");
        }
        this.domainAxis = valueAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) throws AxisNotCompatibleException {
        if (this.isCompatibleRangeAxis(valueAxis)) {
            if (valueAxis != null) {
                try {
                    valueAxis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("Plot.setRangeAxis(...): plot not compatible with axis.");
                }
                valueAxis.addChangeListener(this);
            }
            if (this.rangeAxis != null) {
                this.rangeAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setRangeAxis(...): axis not compatible with plot.");
        }
        this.rangeAxis = valueAxis;
    }
}

