/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.entity;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;

public class ChartEntity {
    protected Shape area;
    protected String toolTipText;

    public ChartEntity(Shape shape, String string) {
        this.area = shape;
        this.toolTipText = string;
    }

    public Shape getArea() {
        return this.area;
    }

    public void setArea(Shape shape) {
        this.area = shape;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String string) {
        this.toolTipText = this.toolTipText;
    }

    public String getShapeType() {
        if (this.area instanceof Rectangle2D) {
            return "RECT";
        }
        return "POLY";
    }

    public String getShapeCoords() {
        if (this.area instanceof Rectangle2D) {
            return this.getRectCoords((Rectangle2D)this.area);
        }
        return this.getPolyCoords(this.area);
    }

    private String getRectCoords(Rectangle2D rectangle2D) {
        int n = (int)rectangle2D.getX();
        int n2 = (int)rectangle2D.getY();
        int n3 = n + (int)rectangle2D.getWidth();
        int n4 = n2 + (int)rectangle2D.getHeight();
        return n + "," + n2 + "," + n3 + "," + n4;
    }

    private String getPolyCoords(Shape shape) {
        String string = "";
        boolean bl = true;
        float[] fArray = new float[6];
        PathIterator pathIterator = shape.getPathIterator(null, 1.0);
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(fArray);
            if (bl) {
                bl = false;
                string = string + (int)fArray[0] + "," + (int)fArray[1];
            } else {
                string = string + "," + (int)fArray[0] + "," + (int)fArray[1];
            }
            pathIterator.next();
        }
        return string;
    }
}

