/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.tooltips;

import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.XYDataset;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeSeriesToolTipGenerator
implements XYToolTipGenerator {
    protected DateFormat domainFormat;
    protected NumberFormat rangeFormat;

    public TimeSeriesToolTipGenerator() {
        this(DateFormat.getInstance(), NumberFormat.getNumberInstance());
    }

    public TimeSeriesToolTipGenerator(String string, String string2) {
        this(new SimpleDateFormat(string), new DecimalFormat(string2));
    }

    public TimeSeriesToolTipGenerator(DateFormat dateFormat, NumberFormat numberFormat) {
        this.domainFormat = dateFormat;
        this.rangeFormat = numberFormat;
    }

    public String generateToolTip(XYDataset xYDataset, int n, int n2) {
        String string = xYDataset.getSeriesName(n) + ": ";
        long l = xYDataset.getXValue(n, n2).longValue();
        string = string + "date = " + this.domainFormat.format(new Date(l));
        Number number = xYDataset.getYValue(n, n2);
        string = number != null ? string + ", value = " + this.rangeFormat.format(number) : string + ", value = null";
        return string;
    }
}

