/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import uk.ac.starlink.table.StarTable;

public class ColumnIdentifier {
    private final StarTable table_;
    private final int ncol_;
    private final String[] colNames_;
    private boolean caseSensitive_;

    public ColumnIdentifier(StarTable table) {
        this.table_ = table;
        this.ncol_ = this.table_.getColumnCount();
        this.colNames_ = new String[this.ncol_];
        int icol = 0;
        while (icol < this.ncol_) {
            String name = this.table_.getColumnInfo(icol).getName();
            if (name != null) {
                this.colNames_[icol] = name.trim();
            }
            ++icol;
        }
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive_ = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive_;
    }

    public int getColumnIndex(String colid) throws IOException {
        int ix = this.getScalarColumnIndex(colid);
        if (ix < 0) {
            throw new IOException("No such column " + colid);
        }
        return ix;
    }

    public int[] getColumnIndices(String colidList) throws IOException {
        String[] colIds = colidList.trim().split("\\s+");
        ArrayList<Integer> icolList = new ArrayList<Integer>();
        int i = 0;
        while (i < colIds.length) {
            String colId = colIds[i];
            int icol = this.getScalarColumnIndex(colId);
            if (icol >= 0) {
                icolList.add(new Integer(icol));
            } else {
                int[] jcols;
                try {
                    jcols = this.findMatchingColumns(colId);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Not a column ID or wildcard: " + colId);
                }
                int j = 0;
                while (j < jcols.length) {
                    icolList.add(new Integer(jcols[j]));
                    ++j;
                }
            }
            ++i;
        }
        int ncol = icolList.size();
        int[] icols = new int[ncol];
        int i2 = 0;
        while (i2 < ncol) {
            icols[i2] = (Integer)icolList.get(i2);
            ++i2;
        }
        return icols;
    }

    public boolean[] getColumnFlags(String colIdList) throws IOException {
        boolean[] colFlags = new boolean[this.ncol_];
        int[] icols = this.getColumnIndices(colIdList);
        int i = 0;
        while (i < icols.length) {
            colFlags[icols[i]] = true;
            ++i;
        }
        return colFlags;
    }

    private int getScalarColumnIndex(String colid) throws IOException {
        if ((colid = colid.trim()).length() == 0) {
            throw new IOException("Blank column ID not allowed");
        }
        if (colid.charAt(0) == '-') {
            throw new IOException("Found " + colid + " while looking for column ID");
        }
        if (colid.matches("[0-9]+")) {
            int ix1 = Integer.parseInt(colid);
            if (ix1 < 1 || ix1 > this.ncol_) {
                throw new IOException("Column index " + ix1 + " out of range " + "1.." + this.ncol_);
            }
            return ix1 - 1;
        }
        int icol = 0;
        while (icol < this.ncol_) {
            String name = this.colNames_[icol];
            if (this.isCaseSensitive() ? colid.equals(name) : colid.equalsIgnoreCase(name)) {
                return icol;
            }
            ++icol;
        }
        return -1;
    }

    private int[] findMatchingColumns(String glob) {
        Pattern regex = ColumnIdentifier.globToRegex(glob, this.isCaseSensitive());
        if (regex == null) {
            throw new IllegalArgumentException("Not a wildcard expression: " + glob);
        }
        int ncol = this.table_.getColumnCount();
        ArrayList<Integer> icolList = new ArrayList<Integer>();
        int icol = 0;
        while (icol < ncol) {
            String colName = this.table_.getColumnInfo(icol).getName();
            if (colName != null && regex.matcher(colName.trim()).matches()) {
                icolList.add(new Integer(icol));
            }
            ++icol;
        }
        int nfound = icolList.size();
        int[] icols = new int[nfound];
        int i = 0;
        while (i < nfound) {
            icols[i] = (Integer)icolList.get(i);
            ++i;
        }
        return icols;
    }

    public static Pattern globToRegex(String glob, boolean caseSensitive) {
        if (glob.indexOf(42) < 0) {
            return null;
        }
        if (glob.indexOf("**") >= 0) {
            throw new IllegalArgumentException("Bad pattern (adjacent wildcards): " + glob);
        }
        StringBuffer sbuf = new StringBuffer();
        boolean quoted = false;
        int i = 0;
        while (i < glob.length()) {
            char c = glob.charAt(i);
            if (c == '*') {
                if (quoted) {
                    sbuf.append("\\E");
                    quoted = false;
                }
                sbuf.append(".*");
            } else {
                if (!quoted) {
                    sbuf.append("\\Q");
                    quoted = true;
                }
                sbuf.append(c);
            }
            ++i;
        }
        String regex = sbuf.toString();
        int flags = caseSensitive ? 0 : 2;
        return Pattern.compile(regex, flags);
    }
}

