/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Formatter {
    private final DocumentBuilder db_;

    public Formatter() {
        try {
            this.db_ = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String formatXML(String xml) throws SAXException {
        return this.formatDOM(this.readDOM(xml));
    }

    private String formatDOM(Document doc) {
        Result result = new Result();
        this.appendChildren(result, doc);
        return result.getText();
    }

    private void appendChildren(Result result, Node node) {
        Node child = node.getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                Element el = (Element)child;
                String tag = el.getTagName();
                if (tag.equals("p")) {
                    this.appendChildren(result, el);
                    result.newLine();
                    result.newLine();
                } else if (tag.equals("ul")) {
                    result.newLine();
                    this.appendChildren(result, el);
                } else if (tag.equals("li")) {
                    result.newLine();
                    result.appendText(" * ");
                    result.incLevel();
                    result.incLevel();
                    this.appendChildren(result, el);
                    result.decLevel();
                    result.decLevel();
                } else if (tag.equals("ref")) {
                    if (el.getFirstChild() != null) {
                        this.appendChildren(result, el);
                    } else {
                        result.appendWords("SUN/256");
                    }
                } else {
                    this.appendChildren(result, child);
                }
            } else if (child instanceof Text) {
                result.appendWords(((Text)child).getData());
            } else {
                throw new IllegalArgumentException("Can't serialize node " + child.getClass());
            }
            child = child.getNextSibling();
        }
    }

    private Document readDOM(String xml) throws SAXException {
        String dxml = "<DOC>" + xml + "</DOC>";
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(dxml.getBytes());
            Document doc = this.db_.parse(in);
            return doc;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static class Result {
        StringBuffer sbuf_ = new StringBuffer();
        StringBuffer line_;
        int level_ = 2;
        int leng_ = 75;
        String pad1_ = "   ";

        Result() {
            this.newLine();
        }

        void appendWords(String words) {
            if (words.length() == 0) {
                return;
            }
            boolean spaceStart = this.isWhitespace(words.charAt(0));
            boolean spaceEnd = this.isWhitespace(words.charAt(words.length() - 1));
            StringTokenizer st = new StringTokenizer(words);
            while (st.hasMoreTokens()) {
                String word = st.nextToken();
                if (this.line_.length() + word.length() > this.leng_) {
                    this.newLine();
                } else if (this.line_.length() > 0 && spaceStart && !this.isWhitespace(this.line_.charAt(this.line_.length() - 1))) {
                    this.line_.append(' ');
                }
                this.line_.append(word);
                if (!st.hasMoreTokens() && spaceEnd && !this.isWhitespace(this.line_.charAt(this.line_.length() - 1))) {
                    this.line_.append(' ');
                }
                spaceStart = true;
            }
        }

        void appendText(String text) {
            this.line_.append(text);
        }

        void incLevel() {
            ++this.level_;
        }

        void decLevel() {
            --this.level_;
        }

        void newLine() {
            if (this.line_ != null) {
                if (this.line_.toString().trim().length() > 0) {
                    this.sbuf_.append(this.line_);
                }
                this.sbuf_.append('\n');
            }
            this.line_ = new StringBuffer();
            int i = 0;
            while (i < this.level_) {
                this.line_.append(this.pad1_);
                ++i;
            }
        }

        String getText() {
            if (this.line_ != null && this.line_.toString().trim().length() > 0) {
                this.sbuf_.append(this.line_);
            }
            return this.sbuf_.toString();
        }

        boolean isWhitespace(char c) {
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }
    }
}

