/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import gnu.jel.CompiledExpression;
import gnu.jel.DVMap;
import java.io.IOException;
import java.util.Date;
import java.util.Random;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;

public abstract class JELRowReader
extends DVMap {
    private final StarTable table_;
    private final Object[] args_;
    private boolean isNullExpression_;
    private final long HASH_LONG = System.identityHashCode(this);
    public static final String NULL_QUERY_PREFIX = "NULL_";
    public static final char COLUMN_ID_CHAR = '$';
    private static final byte INDEX_ID = 1;
    private static final byte NULL_VALUE_ID = 2;
    private static final byte NULL_EXPRESSION_ID = 3;
    private static final byte RANDOM_ID = 4;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class array$Ljava$util$Date;

    public JELRowReader(StarTable table) {
        this.table_ = table;
        this.args_ = new Object[]{this};
    }

    protected abstract Object getCell(int var1) throws IOException;

    public abstract long getCurrentRow();

    public synchronized Object evaluate(CompiledExpression compEx) throws Throwable {
        try {
            this.isNullExpression_ = false;
            Object result = compEx.evaluate(this.args_);
            return this.isNullExpression_ ? null : result;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public String getTypeName(String name) {
        byte ispecial = this.getSpecialId(name);
        if (ispecial >= 0) {
            switch (ispecial) {
                case 1: {
                    return "Long";
                }
                case 2: {
                    return "Object";
                }
                case 3: {
                    return "Byte";
                }
                case 4: {
                    return "Double";
                }
            }
            throw new AssertionError((Object)"Unknown special");
        }
        int inul = this.getNullColumnIndex(name);
        if (inul >= 0) {
            return "Boolean";
        }
        int icol = this.getColumnIndex(name);
        if (icol >= 0) {
            Class clazz = this.table_.getColumnInfo(icol).getContentClass();
            if (clazz.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JELRowReader.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return "Boolean";
            }
            if (clazz.equals(array$Z == null ? (array$Z = JELRowReader.class$("[Z")) : array$Z)) {
                return "BooleanArray";
            }
            if (clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = JELRowReader.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return "Byte";
            }
            if (clazz.equals(array$B == null ? (array$B = JELRowReader.class$("[B")) : array$B)) {
                return "ByteArray";
            }
            if (clazz.equals(class$java$lang$Character == null ? (class$java$lang$Character = JELRowReader.class$("java.lang.Character")) : class$java$lang$Character)) {
                return "Char";
            }
            if (clazz.equals(array$C == null ? (array$C = JELRowReader.class$("[C")) : array$C)) {
                return "CharArray";
            }
            if (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = JELRowReader.class$("java.lang.Short")) : class$java$lang$Short)) {
                return "Short";
            }
            if (clazz.equals(array$S == null ? (array$S = JELRowReader.class$("[S")) : array$S)) {
                return "ShortArray";
            }
            if (clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = JELRowReader.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return "Int";
            }
            if (clazz.equals(array$I == null ? (array$I = JELRowReader.class$("[I")) : array$I)) {
                return "IntArray";
            }
            if (clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = JELRowReader.class$("java.lang.Long")) : class$java$lang$Long)) {
                return "Long";
            }
            if (clazz.equals(array$J == null ? (array$J = JELRowReader.class$("[J")) : array$J)) {
                return "LongArray";
            }
            if (clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = JELRowReader.class$("java.lang.Float")) : class$java$lang$Float)) {
                return "Float";
            }
            if (clazz.equals(array$F == null ? (array$F = JELRowReader.class$("[F")) : array$F)) {
                return "FloatArray";
            }
            if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = JELRowReader.class$("java.lang.Double")) : class$java$lang$Double)) {
                return "Double";
            }
            if (clazz.equals(array$D == null ? (array$D = JELRowReader.class$("[D")) : array$D)) {
                return "DoubleArray";
            }
            if (clazz.equals(class$java$lang$String == null ? (class$java$lang$String = JELRowReader.class$("java.lang.String")) : class$java$lang$String)) {
                return "String";
            }
            if (clazz.equals(array$Ljava$lang$String == null ? (array$Ljava$lang$String = JELRowReader.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
                return "StringArray";
            }
            if (clazz.equals(class$java$util$Date == null ? (class$java$util$Date = JELRowReader.class$("java.util.Date")) : class$java$util$Date)) {
                return "Date";
            }
            if (clazz.equals(array$Ljava$util$Date == null ? (array$Ljava$util$Date = JELRowReader.class$("[Ljava.util.Date;")) : array$Ljava$util$Date)) {
                return "DateArray";
            }
            if (clazz.getComponentType() != null) {
                return "ObjectArray";
            }
            return "Object";
        }
        return null;
    }

    public Object translate(String name) {
        byte ispecial = this.getSpecialId(name);
        if (ispecial >= 0) {
            return new Byte(ispecial);
        }
        int inul = this.getNullColumnIndex(name);
        if (inul >= 0) {
            return new Long(inul);
        }
        int icol = this.getColumnIndex(name);
        if (icol >= 0) {
            return new Integer(icol);
        }
        return null;
    }

    private int getNullColumnIndex(String name) {
        if (name.startsWith(NULL_QUERY_PREFIX)) {
            String colname = name.substring(NULL_QUERY_PREFIX.length());
            return this.getColumnIndex(colname);
        }
        return -1;
    }

    public int getColumnIndex(String name) {
        int icol;
        if (name.length() == 0) {
            return -1;
        }
        if (name.charAt(0) == '$') {
            try {
                icol = Integer.parseInt(name.substring(1)) - 1;
                if (icol >= 0 && icol < this.table_.getColumnCount()) {
                    return icol;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        icol = 0;
        while (icol < this.table_.getColumnCount()) {
            if (this.table_.getColumnInfo(icol).getName().equalsIgnoreCase(name)) {
                return icol;
            }
            ++icol;
        }
        return -1;
    }

    private byte getSpecialId(String name) {
        if (name.equals("$0") || name.equalsIgnoreCase("Index")) {
            return 1;
        }
        if (name.equals("null")) {
            return 2;
        }
        if (name.equals("NULL")) {
            return 3;
        }
        if (name.equals("RANDOM")) {
            return 4;
        }
        return -1;
    }

    public long getLongProperty(byte ispecial) {
        switch (ispecial) {
            case 1: {
                return this.getCurrentRow() + 1L;
            }
        }
        throw new AssertionError();
    }

    public Object getObjectProperty(byte ispecial) {
        switch (ispecial) {
            case 2: {
                return null;
            }
        }
        throw new AssertionError();
    }

    public byte getByteProperty(byte ispecial) {
        switch (ispecial) {
            case 3: {
                this.isNullExpression_ = true;
                return 0;
            }
        }
        throw new AssertionError();
    }

    public double getDoubleProperty(byte ispecial) {
        switch (ispecial) {
            case 4: {
                long seed = this.HASH_LONG + this.getCurrentRow() * 2000000011L;
                return new Random(seed).nextDouble();
            }
        }
        throw new AssertionError();
    }

    public boolean getBooleanProperty(long inul) {
        try {
            return Tables.isBlank(this.getCell((int)inul));
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
    }

    private Object getValue(int icol) {
        try {
            return this.getCell(icol);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean getBooleanProperty(int icol) {
        Boolean value = (Boolean)this.getValue(icol);
        if (value == null) {
            this.isNullExpression_ = true;
            return false;
        }
        return value;
    }

    public boolean[] getBooleanArrayProperty(int icol) {
        return (boolean[])this.getValue(icol);
    }

    public byte getByteProperty(int icol) {
        Byte value = (Byte)this.getValue(icol);
        if (value == null) {
            this.isNullExpression_ = true;
            return 0;
        }
        return value;
    }

    public byte[] getByteArrayProperty(int icol) {
        return (byte[])this.getValue(icol);
    }

    public char getCharProperty(int icol) {
        Character value = (Character)this.getValue(icol);
        if (value == null) {
            this.isNullExpression_ = true;
            return '\u0000';
        }
        return value.charValue();
    }

    public char[] getCharArrayProperty(int icol) {
        return (char[])this.getValue(icol);
    }

    public short getShortProperty(int icol) {
        Short value = (Short)this.getValue(icol);
        if (value == null) {
            this.isNullExpression_ = true;
            return 0;
        }
        return value;
    }

    public short[] getShortArrayProperty(int icol) {
        return (short[])this.getValue(icol);
    }

    public int getIntProperty(int icol) {
        Integer value = (Integer)this.getValue(icol);
        if (value == null) {
            this.isNullExpression_ = true;
            return 0;
        }
        return value;
    }

    public int[] getIntArrayProperty(int icol) {
        return (int[])this.getValue(icol);
    }

    public long getLongProperty(int icol) {
        Long value = (Long)this.getValue(icol);
        if (value == null) {
            this.isNullExpression_ = true;
            return 0L;
        }
        return value;
    }

    public long[] getLongArrayProperty(int icol) {
        return (long[])this.getValue(icol);
    }

    public float getFloatProperty(int icol) {
        Float value = (Float)this.getValue(icol);
        return value == null ? Float.NaN : value.floatValue();
    }

    public float[] getFloatArrayProperty(int icol) {
        return (float[])this.getValue(icol);
    }

    public double getDoubleProperty(int icol) {
        Double value = (Double)this.getValue(icol);
        return value == null ? Double.NaN : value;
    }

    public double[] getDoubleArrayProperty(int icol) {
        return (double[])this.getValue(icol);
    }

    public String getStringProperty(int icol) {
        return (String)this.getValue(icol);
    }

    public String[] getStringArrayProperty(int icol) {
        return (String[])this.getValue(icol);
    }

    public Date getDateProperty(int icol) {
        return (Date)this.getValue(icol);
    }

    public Date[] getDateArrayProperty(int icol) {
        return (Date[])this.getValue(icol);
    }

    public Object getObjectProperty(int icol) {
        return this.getValue(icol);
    }

    public Object[] getObjectArrayProperty(int icol) {
        return (Object[])this.getValue(icol);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

