/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.LoadException;

public class ObjectFactory {
    private final Class superClass_;
    private Map nameMap_ = new HashMap();
    private List nameList_ = new ArrayList();
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools");

    public ObjectFactory(Class clazz) {
        this.superClass_ = clazz;
    }

    public void register(String nickName, String className) {
        this.nameList_.add(nickName);
        this.nameMap_.put(nickName, className);
    }

    public String[] getNickNames() {
        return this.nameList_.toArray(new String[0]);
    }

    public boolean isRegistered(String nickName) {
        return this.nameMap_.containsKey(nickName);
    }

    public Object createObject(String nickName) throws LoadException {
        Class<?> clazz;
        if (!this.isRegistered(nickName)) {
            throw new IllegalArgumentException("Unknown nickname " + nickName);
        }
        String className = (String)this.nameMap_.get(nickName);
        logger_.config("Instantiating " + className + " for " + nickName);
        try {
            clazz = Class.forName(className);
        }
        catch (LinkageError e) {
            throw new LoadException(nickName + ": can't load " + className, e);
        }
        catch (ClassNotFoundException e) {
            throw new LoadException(nickName + ": can't load " + className, e);
        }
        if (!this.superClass_.isAssignableFrom(clazz)) {
            throw new ClassCastException(clazz + " does not subclass " + this.superClass_);
        }
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No no-arg constructor for " + clazz, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

