/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.io.IOException;
import java.util.LinkedList;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.StreamRereadException;

public class StreamRowStore
implements TableSink,
RowSequence {
    private final LinkedList rowQueue_;
    private final int queueSize_;
    private StarTable table_;
    private Object[] seqRow_;
    private boolean seqClosed_;
    private IOException error_;
    private static final Object[] END_ROWS = new Object[0];

    public StreamRowStore() {
        this(1024);
    }

    public StreamRowStore(int queueSize) {
        this.queueSize_ = queueSize;
        this.rowQueue_ = new LinkedList();
    }

    public synchronized void setError(IOException error) {
        this.error_ = error;
        this.notifyAll();
    }

    public synchronized void acceptMetadata(StarTable meta) {
        this.table_ = new WrapperStarTable(meta){
            RowSequence rseq_;
            {
                this.rseq_ = StreamRowStore.this;
            }

            public boolean isRandom() {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RowSequence getRowSequence() throws IOException {
                StreamRowStore streamRowStore = StreamRowStore.this;
                synchronized (streamRowStore) {
                    if (this.rseq_ == null) {
                        throw new StreamRereadException();
                    }
                    if (StreamRowStore.this.error_ != null) {
                        throw StreamRowStore.this.error_;
                    }
                    RowSequence rseq = this.rseq_;
                    this.rseq_ = null;
                    return rseq;
                }
            }
        };
    }

    public synchronized void acceptRow(Object[] row) throws IOException {
        if (this.seqClosed_) {
            throw new IOException("Stream closed at reading end");
        }
        try {
            while (this.rowQueue_.size() > this.queueSize_) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new IOException("Thread interrupted").initCause(e);
        }
        this.rowQueue_.addLast(row);
        this.notifyAll();
    }

    public synchronized void endRows() {
        this.rowQueue_.addLast(END_ROWS);
        this.notifyAll();
    }

    public synchronized StarTable waitForStarTable() throws IOException {
        try {
            while (this.table_ == null && this.error_ == null) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Thread interrupted", e);
        }
        if (this.error_ != null) {
            throw this.error_;
        }
        return this.table_;
    }

    public synchronized boolean next() throws IOException {
        if (this.error_ != null) {
            throw this.error_;
        }
        try {
            while (this.rowQueue_.size() == 0) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new IOException("Thread interrupted").initCause(e);
        }
        this.seqRow_ = (Object[])this.rowQueue_.removeFirst();
        this.notifyAll();
        return this.seqRow_ != END_ROWS;
    }

    public synchronized Object[] getRow() {
        return this.seqRow_;
    }

    public Object getCell(int icol) {
        return this.getRow()[icol];
    }

    public synchronized void close() {
        this.seqClosed_ = true;
    }
}

