/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools;

import java.util.ArrayList;
import uk.ac.starlink.task.UsageException;

public class Tokenizer {
    private Tokenizer() {
    }

    public static String[] tokenizeLines(String text) throws UsageException {
        ArrayList<String> tokenList = new ArrayList<String>();
        String text1 = text + ";";
        char delim = '\u0000';
        StringBuffer token = new StringBuffer();
        int i = 0;
        while (i < text1.length()) {
            char chr = text1.charAt(i);
            switch (chr) {
                case '\n': 
                case ';': {
                    if (delim == '\u0000') {
                        tokenList.add(token.toString());
                        token = new StringBuffer();
                        break;
                    }
                    token.append(chr);
                    break;
                }
                case '\"': 
                case '\'': {
                    if (delim == chr) {
                        delim = '\u0000';
                    } else if (delim == '\u0000') {
                        delim = chr;
                    }
                    token.append(chr);
                    break;
                }
                default: {
                    token.append(chr);
                }
            }
            ++i;
        }
        if (token.length() > 0 || delim != '\u0000') {
            throw new UsageException("Badly formed input: " + text);
        }
        return tokenList.toArray(new String[0]);
    }

    public static String[] tokenizeWords(String line) throws UsageException {
        String line1 = line + '\n';
        ArrayList<String> tokenList = new ArrayList<String>();
        StringBuffer token = null;
        char delim = '\u0000';
        boolean done = false;
        int i = 0;
        while (i < line1.length() && !done) {
            char chr = line1.charAt(i);
            switch (chr) {
                case '#': {
                    if (delim == '\u0000') {
                        done = true;
                        break;
                    }
                    token.append(chr);
                    break;
                }
                case '\t': 
                case '\n': 
                case ' ': {
                    if (token == null) break;
                    if (delim == '\u0000') {
                        tokenList.add(token.toString());
                        token = null;
                        break;
                    }
                    token.append(chr);
                    break;
                }
                case '\"': 
                case '\'': {
                    if (token == null) {
                        token = new StringBuffer();
                        delim = chr;
                        break;
                    }
                    if (delim == chr) {
                        tokenList.add(token.toString());
                        token = null;
                        delim = '\u0000';
                        break;
                    }
                    if (delim == '\u0000') {
                        delim = chr;
                        break;
                    }
                    token.append(chr);
                    break;
                }
                case '\\': {
                    if (i == line1.length() - 1) {
                        throw new UsageException("Backslash illegal at end of line");
                    }
                    if (token == null) {
                        token = new StringBuffer();
                    }
                    token.append(line1.charAt(++i));
                    break;
                }
                default: {
                    if (token == null) {
                        token = new StringBuffer();
                    }
                    token.append(chr);
                }
            }
            ++i;
        }
        if (token != null || delim != '\u0000') {
            throw new UsageException("Badly formed line: " + line);
        }
        return tokenList.toArray(new String[0]);
    }
}

