/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.io.PrintStream;
import java.util.Arrays;
import uk.ac.starlink.ttools.LoadException;
import uk.ac.starlink.ttools.ObjectFactory;
import uk.ac.starlink.ttools.filter.ProcessingFilter;
import uk.ac.starlink.ttools.filter.StepFactory;

public class FilterDoc {
    private final PrintStream out_;

    private FilterDoc(PrintStream out) {
        this.out_ = out;
    }

    private void write() throws LoadException {
        ObjectFactory stepFact = StepFactory.getInstance().getFilterFactory();
        Object[] fnames = stepFact.getNickNames();
        Arrays.sort(fnames);
        this.out_.println("<dl>");
        int i = 0;
        while (i < fnames.length) {
            Object name = fnames[i];
            ProcessingFilter filter = (ProcessingFilter)stepFact.createObject((String)name);
            this.out_.print("<dt><verbatim>" + (String)name);
            String usage = filter.getUsage();
            String pad = ((String)name).replaceAll(".", " ");
            if (usage != null) {
                this.out_.print(" " + usage.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "\n " + pad));
            }
            this.out_.println("</verbatim></dt>");
            this.out_.println("<dd><p>");
            String descrip = filter.getDescription();
            if (descrip == null) {
                throw new IllegalArgumentException("No description for filter " + (String)name);
            }
            this.out_.print(descrip);
            this.out_.println("</p></dd>");
            ++i;
        }
        this.out_.println("</dl>");
    }

    public static void main(String[] args) throws LoadException {
        new FilterDoc(System.out).write();
    }
}

