/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.io.PrintStream;
import java.util.Arrays;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.ttools.LoadException;
import uk.ac.starlink.ttools.ObjectFactory;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.build.UsageWriter;
import uk.ac.starlink.ttools.mode.ProcessingMode;

public class ModeDoc {
    private final PrintStream out_;

    private ModeDoc(PrintStream out) {
        this.out_ = out;
    }

    private void write() throws LoadException {
        ObjectFactory modeFact = Stilts.getModeFactory();
        Object[] mnames = modeFact.getNickNames();
        Arrays.sort(mnames);
        this.out_.println("<dl>");
        int i = 0;
        while (i < mnames.length) {
            Object name = mnames[i];
            ProcessingMode mode = (ProcessingMode)modeFact.createObject((String)name);
            this.out_.println("<dt><code>mode=" + (String)name + "</code></dt>");
            this.out_.println("<dd>");
            this.out_.println("<p>" + mode.getDescription() + "</p>");
            Parameter[] params = mode.getAssociatedParameters();
            if (params.length > 0) {
                this.out_.println("<p>Additional parameters for this output mode are:<dl>");
                int j = 0;
                while (j < params.length) {
                    this.out_.println(UsageWriter.xmlItem(params[j]));
                    ++j;
                }
                this.out_.println("</dl></p>");
            }
            this.out_.println("</dd>");
            ++i;
        }
        this.out_.println("</dl>");
    }

    public static void main(String[] args) throws LoadException {
        new ModeDoc(System.out).write();
    }
}

