/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.convert;

import uk.ac.starlink.pal.AngleDR;
import uk.ac.starlink.pal.Galactic;
import uk.ac.starlink.pal.Pal;
import uk.ac.starlink.ttools.func.Times;

public abstract class SkySystem {
    private static final SkySystem[] KNOWN_SYSTEMS = new SkySystem[]{new FK5System("fk5"), new FK4System("fk4"), new GalSystem("galactic"), new SuperGalSystem("supergalactic"), new EclipticSystem("ecliptic")};
    private static final Pal PAL = new Pal();
    private static final double FK5_EPOCH = 2000.0;
    private final String name_;
    private final String description_;
    private final String coord1_;
    private final String coord2_;

    protected SkySystem(String name, String description, String coord1, String coord2) {
        this.name_ = name;
        this.description_ = description;
        this.coord1_ = coord1;
        this.coord2_ = coord2;
    }

    public abstract double[] fromFK5(double var1, double var3, double var5);

    public abstract double[] toFK5(double var1, double var3, double var5);

    public String getName() {
        return this.name_;
    }

    public String getDescription() {
        return this.description_;
    }

    public String[] getCoordinateDescriptions() {
        return new String[]{this.getDescription() + " " + this.coord1_, this.getDescription() + " " + this.coord2_};
    }

    public String[] getCoordinateNames() {
        return new String[]{this.coord1_, this.coord2_};
    }

    public String toString() {
        return this.getName();
    }

    public static SkySystem[] getKnownSystems() {
        return (SkySystem[])KNOWN_SYSTEMS.clone();
    }

    public static String getSystemUsage() {
        StringBuffer sbuf = new StringBuffer("<ul>");
        int i = 0;
        while (i < KNOWN_SYSTEMS.length) {
            SkySystem sys = KNOWN_SYSTEMS[i];
            sbuf.append("<li><code>").append(sys.getName().toLowerCase()).append("</code>: ").append(sys.getDescription()).append(" (").append(sys.coord1_).append(", ").append(sys.coord2_).append(")</li>").append('\n');
            ++i;
        }
        sbuf.append("</ul>\n");
        return sbuf.toString();
    }

    public static SkySystem getSystemFor(String sysName) {
        String lname = sysName.toLowerCase();
        SkySystem gotSys = null;
        int i = 0;
        while (i < KNOWN_SYSTEMS.length) {
            SkySystem iSys = KNOWN_SYSTEMS[i];
            if (iSys.getName().toLowerCase().startsWith(lname)) {
                if (gotSys == null) {
                    gotSys = iSys;
                } else {
                    throw new IllegalArgumentException("Ambiguous system name: " + sysName);
                }
            }
            ++i;
        }
        if (gotSys == null) {
            StringBuffer sbuf = new StringBuffer().append("Unknown system name: ").append(sysName).append("\nKnown Systems: ");
            int i2 = 0;
            while (i2 < KNOWN_SYSTEMS.length) {
                if (i2 > 0) {
                    sbuf.append(", ");
                }
                sbuf.append(KNOWN_SYSTEMS[i2].getName().toLowerCase());
                ++i2;
            }
            sbuf.append('.');
            throw new IllegalArgumentException(sbuf.toString());
        }
        return gotSys;
    }

    private static class EclipticSystem
    extends SkySystem {
        public EclipticSystem(String name) {
            super(name, "Ecliptic", "Longitude", "Latitude");
        }

        public double[] fromFK5(double c1, double c2, double epoch) {
            double mjd = Times.julianToMjd(epoch);
            AngleDR in = new AngleDR(c1, c2);
            AngleDR out = PAL.Eqecl(in, mjd);
            return new double[]{out.getAlpha(), out.getDelta()};
        }

        public double[] toFK5(double c1, double c2, double epoch) {
            double mjd = Times.julianToMjd(epoch);
            AngleDR in = new AngleDR(c1, c2);
            AngleDR out = PAL.Ecleq(in, mjd);
            return new double[]{out.getAlpha(), out.getDelta()};
        }
    }

    private static class SuperGalSystem
    extends SkySystem {
        public SuperGalSystem(String name) {
            super(name, "de Vaucouleurs Supergalactic", "Longitude", "Latitude");
        }

        public double[] fromFK5(double c1, double c2, double epoch) {
            AngleDR in = new AngleDR(c1, c2);
            Galactic out = PAL.Galsup(PAL.Eqgal(in));
            return new double[]{out.getLongitude(), out.getLatitude()};
        }

        public double[] toFK5(double c1, double c2, double epoch) {
            Galactic in = new Galactic(c1, c2);
            AngleDR out = PAL.Galeq(PAL.Supgal(in));
            return new double[]{out.getAlpha(), out.getDelta()};
        }
    }

    private static class GalSystem
    extends SkySystem {
        public GalSystem(String name) {
            super(name, "IAU 1958 Galactic", "Longitude", "Latitude");
        }

        public double[] fromFK5(double c1, double c2, double epoch) {
            AngleDR in = new AngleDR(c1, c2);
            Galactic out = PAL.Eqgal(in);
            return new double[]{out.getLongitude(), out.getLatitude()};
        }

        public double[] toFK5(double c1, double c2, double epoch) {
            Galactic in = new Galactic(c1, c2);
            AngleDR out = PAL.Galeq(in);
            return new double[]{out.getAlpha(), out.getDelta()};
        }
    }

    private static class FK4System
    extends SkySystem {
        public FK4System(String name) {
            super(name, "FK4 B1950.0", "Right Ascension", "Declination");
        }

        public double[] fromFK5(double c1, double c2, double epoch) {
            AngleDR in = new AngleDR(c1, c2);
            AngleDR out = PAL.Fk54z(in, epoch).getAngle();
            return new double[]{out.getAlpha(), out.getDelta()};
        }

        public double[] toFK5(double c1, double c2, double epoch) {
            AngleDR in = new AngleDR(c1, c2);
            AngleDR out = PAL.Fk45z(in, epoch);
            return new double[]{out.getAlpha(), out.getDelta()};
        }
    }

    private static class FK5System
    extends SkySystem {
        public FK5System(String name) {
            super(name, "FK5 J2000.0", "Right Ascension", "Declination");
        }

        public double[] fromFK5(double c1, double c2, double epoch) {
            AngleDR in = new AngleDR(c1, c2);
            AngleDR out = PAL.Preces("FK5", epoch, 2000.0, in);
            return new double[]{out.getAlpha(), out.getDelta()};
        }

        public double[] toFK5(double c1, double c2, double epoch) {
            AngleDR in = new AngleDR(c1, c2);
            AngleDR out = PAL.Preces("FK5", 2000.0, epoch, in);
            return new double[]{out.getAlpha(), out.getDelta()};
        }
    }
}

