/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.copy;

import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

class SAXWriter
implements ContentHandler,
LexicalHandler {
    private Writer out_;
    private Locator locator_;
    private String pendingTag_;
    private boolean cdata_;

    SAXWriter() {
    }

    public void setOutput(Writer out) {
        this.out_ = out;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator_ = locator;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        this.out("\n");
        try {
            this.out_.flush();
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
        this.locator_ = null;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.flushTag();
        StringBuffer buf = new StringBuffer("<" + qName);
        int i = 0;
        while (i < atts.getLength()) {
            buf.append(' ').append(atts.getQName(i)).append("=\"");
            String value = atts.getValue(i);
            int j = 0;
            while (j < value.length()) {
                char c = value.charAt(j);
                switch (c) {
                    case '<': {
                        buf.append("&lt;");
                        break;
                    }
                    case '>': {
                        buf.append("&gt;");
                        break;
                    }
                    case '&': {
                        buf.append("&amp;");
                        break;
                    }
                    case '\"': {
                        buf.append("&quot;");
                        break;
                    }
                    default: {
                        buf.append(c);
                    }
                }
                ++j;
            }
            buf.append('\"');
            ++i;
        }
        this.pendingTag_ = buf.toString();
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.pendingTag_ != null) {
            this.out(this.pendingTag_);
            this.out("/>");
            this.pendingTag_ = null;
        } else {
            this.out("</" + qName + ">");
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.flushTag();
        this.escapeOut(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.flushTag();
        this.out(ch, start, length);
    }

    public void skippedEntity(String name) throws SAXException {
        this.flushTag();
        this.out("&" + name + ";");
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.flushTag();
        this.out("<?" + target);
        this.escapeOut(data);
        this.out("?>");
    }

    public void startPrefixMapping(String prefix, String uri) {
    }

    public void endPrefixMapping(String prefix) {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.flushTag();
        this.out("<!--");
        this.out(ch, start, length);
        this.out("-->");
    }

    public void startCDATA() throws SAXException {
        this.flushTag();
        this.out("<![CDATA[");
        this.cdata_ = true;
    }

    public void endCDATA() throws SAXException {
        this.out("]]>");
        this.cdata_ = false;
    }

    public void startDTD(String name, String publicId, String systemId) {
    }

    public void endDTD() {
    }

    public void startEntity(String name) {
    }

    public void endEntity(String name) {
    }

    public void flush() throws SAXException {
        this.flushTag();
    }

    private void flushTag() throws SAXException {
        if (this.pendingTag_ != null) {
            this.out(this.pendingTag_);
            this.out('>');
            this.pendingTag_ = null;
        }
    }

    private SAXException wrapException(IOException e) {
        return (SAXException)new SAXParseException(e.getMessage(), this.locator_).initCause(e);
    }

    private void out(char c) throws SAXException {
        try {
            this.out_.write(c);
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    private void out(char[] ch, int start, int leng) throws SAXException {
        try {
            this.out_.write(ch, start, leng);
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    private void out(String text) throws SAXException {
        try {
            this.out_.write(text);
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    private void escapeOut(String text) throws SAXException {
        this.escapeOut(text.toCharArray(), 0, text.length());
    }

    /*
     * Unable to fully structure code
     */
    private void escapeOut(char[] ch, int start, int leng) throws SAXException {
        block9: {
            try {
                if (!this.cdata_) ** GOTO lbl21
                this.out(ch, start, leng);
                break block9;
lbl-1000:
                // 1 sources

                {
                    c = ch[start++];
                    switch (c) {
                        case '<': {
                            this.out_.write("&lt;");
                            break;
                        }
                        case '>': {
                            this.out_.write("&gt;");
                            break;
                        }
                        case '&': {
                            this.out_.write("&amp;");
                            break;
                        }
                        case '\"': {
                            this.out_.write("&quot;");
                            break;
                        }
                        default: {
                            this.out_.write(c);
                        }
                    }
lbl21:
                    // 6 sources

                    ** while (leng-- > 0)
                }
lbl22:
                // 1 sources

            }
            catch (IOException e) {
                throw this.wrapException(e);
            }
        }
    }
}

