/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public abstract class AddColumnsTable
extends WrapperStarTable {
    private final StarTable baseTable_;
    private final int[] inColIndices_;
    private final ColumnInfo[] outColInfos_;
    private final int[] colMap_;
    private long currentRow_ = -1L;
    private Object[] outValues_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$filter$AddColumnsTable;

    public AddColumnsTable(StarTable baseTable, int[] inColIndices, ColumnInfo[] outColInfos, int ipos) {
        super(baseTable);
        this.baseTable_ = baseTable;
        this.inColIndices_ = inColIndices;
        this.outColInfos_ = outColInfos;
        this.colMap_ = new int[baseTable.getColumnCount() + outColInfos.length];
        int j = 0;
        int i = 0;
        while (i < this.colMap_.length) {
            this.colMap_[i] = i >= ipos && i < ipos + outColInfos.length ? ipos - i - 1 : j++;
            ++i;
        }
        if (!$assertionsDisabled && j != baseTable.getColumnCount()) {
            throw new AssertionError();
        }
    }

    protected abstract Object[] calculateValues(Object[] var1);

    public int getColumnCount() {
        return this.colMap_.length;
    }

    public ColumnInfo getColumnInfo(int icol) {
        int ibase = this.colMap_[icol];
        return ibase >= 0 ? super.getColumnInfo(ibase) : this.outColInfos_[-1 - ibase];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCell(long irow, int icol) throws IOException {
        int ibase = this.colMap_[icol];
        if (ibase >= 0) {
            return super.getCell(irow, ibase);
        }
        AddColumnsTable addColumnsTable = this;
        synchronized (addColumnsTable) {
            if (irow != this.currentRow_ || this.currentRow_ < 0L) {
                this.currentRow_ = -1L;
                Object[] inValues = new Object[this.inColIndices_.length];
                int i = 0;
                while (i < this.inColIndices_.length) {
                    inValues[i] = super.getCell(irow, this.inColIndices_[i]);
                    ++i;
                }
                this.outValues_ = this.calculateValues(inValues);
                this.currentRow_ = irow;
            }
            if (!$assertionsDisabled && irow != this.currentRow_) {
                throw new AssertionError();
            }
            return this.outValues_[-1 - ibase];
        }
    }

    public Object[] getRow(long irow) throws IOException {
        return this.calculateRow(super.getRow(irow));
    }

    private Object[] calculateRow(Object[] baseRow) {
        Object[] inValues = new Object[this.inColIndices_.length];
        int i = 0;
        while (i < this.inColIndices_.length) {
            inValues[i] = baseRow[this.inColIndices_[i]];
            ++i;
        }
        Object[] outVals = this.calculateValues(inValues);
        Object[] row = new Object[this.colMap_.length];
        int icol = 0;
        while (icol < row.length) {
            int ibase = this.colMap_[icol];
            row[icol] = ibase >= 0 ? baseRow[ibase] : outVals[-1 - ibase];
            ++icol;
        }
        return row;
    }

    public RowSequence getRowSequence() throws IOException {
        return new WrapperRowSequence(super.getRowSequence()){
            private Object[] seqOutValues_;

            public boolean next() throws IOException {
                this.seqOutValues_ = null;
                return super.next();
            }

            public Object getCell(int icol) throws IOException {
                int ibase = AddColumnsTable.this.colMap_[icol];
                if (ibase >= 0) {
                    return super.getCell(icol);
                }
                if (this.seqOutValues_ == null) {
                    Object[] inValues = new Object[AddColumnsTable.this.inColIndices_.length];
                    int i = 0;
                    while (i < AddColumnsTable.this.inColIndices_.length) {
                        inValues[i] = super.getCell(AddColumnsTable.this.inColIndices_[i]);
                        ++i;
                    }
                    this.seqOutValues_ = AddColumnsTable.this.calculateValues(inValues);
                }
                return this.seqOutValues_[-1 - ibase];
            }

            public Object[] getRow() throws IOException {
                return AddColumnsTable.this.calculateRow(super.getRow());
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$ttools$filter$AddColumnsTable == null ? (class$uk$ac$starlink$ttools$filter$AddColumnsTable = AddColumnsTable.class$("uk.ac.starlink.ttools.filter.AddColumnsTable")) : class$uk$ac$starlink$ttools$filter$AddColumnsTable).desiredAssertionStatus();
    }
}

