/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import java.io.IOException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.JELUtils;
import uk.ac.starlink.ttools.RandomJELRowReader;
import uk.ac.starlink.ttools.SequentialJELRowReader;

public class AddJELColumnTable
extends WrapperStarTable {
    private final int nAdded_;
    private final StarTable baseTable_;
    private final String[] exprs_;
    private final int[] colMap_;
    private final RandomJELRowReader randomReader_;
    private final CompiledExpression[] randomCompexs_;
    private final ColumnInfo[] addInfos_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$filter$AddJELColumnTable;

    public AddJELColumnTable(StarTable baseTable, ColumnInfo cinfo, String expr, int ipos) throws CompilationException {
        this(baseTable, new ColumnInfo[]{cinfo}, new String[]{expr}, ipos);
    }

    public AddJELColumnTable(StarTable baseTable, ColumnInfo[] cinfos, String[] exprs, int ipos) throws CompilationException {
        super(baseTable);
        this.baseTable_ = baseTable;
        this.exprs_ = (String[])exprs.clone();
        this.nAdded_ = this.exprs_.length;
        if (cinfos.length != this.nAdded_) {
            throw new IllegalArgumentException("How many new columns??");
        }
        this.colMap_ = new int[baseTable.getColumnCount() + this.nAdded_];
        int j = 0;
        int i = 0;
        while (i < this.colMap_.length) {
            int k = i - ipos;
            this.colMap_[i] = k >= 0 && k < this.nAdded_ ? -(k + 1) : j++;
            ++i;
        }
        if (!$assertionsDisabled && j != baseTable.getColumnCount()) {
            throw new AssertionError();
        }
        this.randomReader_ = new RandomJELRowReader(baseTable);
        Library lib = JELUtils.getLibrary(this.randomReader_);
        this.randomCompexs_ = new CompiledExpression[this.nAdded_];
        this.addInfos_ = new ColumnInfo[this.nAdded_];
        int i2 = 0;
        while (i2 < this.nAdded_) {
            String expr = this.exprs_[i2];
            this.randomCompexs_[i2] = Evaluator.compile(expr, lib);
            Class primType = JELUtils.getExpressionType(lib, expr);
            Class clazz = JELUtils.getWrapperType(primType);
            this.addInfos_[i2] = cinfos[i2];
            this.addInfos_[i2].setContentClass(clazz);
            ++i2;
        }
    }

    public int getColumnCount() {
        return this.colMap_.length;
    }

    public ColumnInfo getColumnInfo(int icol) {
        int ibase = this.colMap_[icol];
        return ibase >= 0 ? super.getColumnInfo(ibase) : this.addInfos_[-1 - ibase];
    }

    public Object getCell(long irow, int icol) throws IOException {
        int ibase = this.colMap_[icol];
        return ibase >= 0 ? super.getCell(irow, ibase) : this.evaluateAtRow(irow, -1 - ibase);
    }

    public Object[] getRow(long irow) throws IOException {
        Object[] baseRow = super.getRow(irow);
        int ncol = this.colMap_.length;
        if (!$assertionsDisabled && ncol != baseRow.length + 1) {
            throw new AssertionError();
        }
        Object[] row = new Object[ncol];
        int icol = 0;
        while (icol < ncol) {
            int ibase = this.colMap_[icol];
            row[icol] = ibase >= 0 ? baseRow[ibase] : this.evaluateAtRow(irow, -1 - ibase);
            ++icol;
        }
        return row;
    }

    public RowSequence getRowSequence() throws IOException {
        final SequentialJELRowReader seqReader = new SequentialJELRowReader(this.baseTable_);
        final CompiledExpression[] seqCompexs = new CompiledExpression[this.nAdded_];
        Library lib = JELUtils.getLibrary(seqReader);
        int i = 0;
        while (i < this.nAdded_) {
            try {
                seqCompexs[i] = Evaluator.compile(this.exprs_[i], lib);
            }
            catch (CompilationException e) {
                throw (IOException)new IOException("Bad expression: " + this.exprs_[i]).initCause(e);
            }
            ++i;
        }
        return new WrapperRowSequence(seqReader){
            static final /* synthetic */ boolean $assertionsDisabled;

            public Object getCell(int icol) throws IOException {
                int ibase = AddJELColumnTable.this.colMap_[icol];
                return ibase >= 0 ? super.getCell(ibase) : this.evaluate(-1 - ibase);
            }

            public Object[] getRow() throws IOException {
                Object[] baseRow = super.getRow();
                int ncol = AddJELColumnTable.this.colMap_.length;
                if (!$assertionsDisabled && ncol != baseRow.length + 1) {
                    throw new AssertionError();
                }
                Object[] row = new Object[ncol];
                int icol = 0;
                while (icol < ncol) {
                    int ibase = AddJELColumnTable.this.colMap_[icol];
                    row[icol] = ibase >= 0 ? baseRow[ibase] : this.evaluate(-1 - ibase);
                    ++icol;
                }
                return row;
            }

            private Object evaluate(int iAddcol) throws IOException {
                try {
                    return seqReader.evaluate(seqCompexs[iAddcol]);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }

            static {
                $assertionsDisabled = !(class$uk$ac$starlink$ttools$filter$AddJELColumnTable == null ? (class$uk$ac$starlink$ttools$filter$AddJELColumnTable = AddJELColumnTable.class$("uk.ac.starlink.ttools.filter.AddJELColumnTable")) : class$uk$ac$starlink$ttools$filter$AddJELColumnTable).desiredAssertionStatus();
            }
        };
    }

    private Object evaluateAtRow(long irow, int iAddcol) throws IOException {
        try {
            return this.randomReader_.evaluateAtRow(this.randomCompexs_[iAddcol], irow);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$ttools$filter$AddJELColumnTable == null ? (class$uk$ac$starlink$ttools$filter$AddJELColumnTable = AddJELColumnTable.class$("uk.ac.starlink.ttools.filter.AddJELColumnTable")) : class$uk$ac$starlink$ttools$filter$AddJELColumnTable).desiredAssertionStatus();
    }
}

