/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.ColumnIdentifier;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class DeleteColumnFilter
extends BasicFilter {
    public DeleteColumnFilter() {
        super("delcols", "<colid-list>");
    }

    protected String[] getDescriptionLines() {
        return new String[]{"Delete the specified columns.", "The same column may harmlessly be specified more than once."};
    }

    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        if (argIt.hasNext()) {
            String colIdList = (String)argIt.next();
            argIt.remove();
            return new DeleteColumnStep(colIdList);
        }
        throw new ArgException("Missing column list");
    }

    private static class DeleteColumnStep
    implements ProcessingStep {
        final String colidList_;

        DeleteColumnStep(String colidList) {
            this.colidList_ = colidList;
        }

        public StarTable wrap(StarTable base) throws IOException {
            int[] idels = new ColumnIdentifier(base).getColumnIndices(this.colidList_);
            return ColumnPermutedStarTable.deleteColumns(base, idels);
        }
    }
}

