/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.util.Iterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.EveryTable;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class EveryFilter
extends BasicFilter {
    public EveryFilter() {
        super("every", "<step>");
    }

    protected String[] getDescriptionLines() {
        return new String[]{"Include only every <code>&lt;step&gt;</code>'th row in the", "result, starting with the first row."};
    }

    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        if (argIt.hasNext()) {
            long count;
            String countStr = (String)argIt.next();
            argIt.remove();
            try {
                count = Long.parseLong(countStr);
            }
            catch (NumberFormatException e) {
                throw new ArgException("Step value " + countStr + " not numeric");
            }
            if (count <= 0L) {
                throw new ArgException("Step must be >= 1");
            }
            return new EveryStep(count);
        }
        throw new ArgException("No step given");
    }

    private static class EveryStep
    implements ProcessingStep {
        final long count_;

        EveryStep(long count) {
            this.count_ = count;
        }

        public StarTable wrap(StarTable base) {
            return new EveryTable(base, this.count_);
        }
    }
}

