/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.util.Iterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.HeadTable;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class HeadFilter
extends BasicFilter {
    public HeadFilter() {
        super("head", "<nrows>");
    }

    protected String[] getDescriptionLines() {
        return new String[]{"Include only the first <code>&lt;nrows&gt;</code> rows of", "the table."};
    }

    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        if (argIt.hasNext()) {
            long count;
            String countStr = (String)argIt.next();
            argIt.remove();
            try {
                count = Long.parseLong(countStr);
            }
            catch (NumberFormatException e) {
                throw new ArgException("Row count " + countStr + " not numeric");
            }
            if (count < 0L) {
                throw new ArgException("Nrows must be >= 0");
            }
            return new HeadStep(count);
        }
        throw new ArgException("No row count given");
    }

    private static class HeadStep
    implements ProcessingStep {
        final long count_;

        HeadStep(long count) {
            this.count_ = count;
        }

        public StarTable wrap(StarTable base) {
            return new HeadTable(base, this.count_);
        }
    }
}

