/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.util.Iterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class NameFilter
extends BasicFilter {
    public NameFilter() {
        super("tablename", "<name>");
    }

    protected String[] getDescriptionLines() {
        return new String[]{"Sets the table's name attribute to the given string."};
    }

    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        if (argIt.hasNext()) {
            final String name = (String)argIt.next();
            argIt.remove();
            return new ProcessingStep(){

                public StarTable wrap(StarTable base) {
                    base.setName(name);
                    return base;
                }
            };
        }
        throw new ArgException("No name given");
    }
}

