/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.PrintStream;
import java.util.Iterator;
import uk.ac.starlink.table.ProgressLineStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class ProgressFilter
extends BasicFilter
implements ProcessingStep {
    private final PrintStream pstrm_;

    public ProgressFilter() {
        this(System.err);
    }

    public ProgressFilter(PrintStream pstrm) {
        super("progress", null);
        this.pstrm_ = pstrm;
    }

    protected String[] getDescriptionLines() {
        return new String[]{"Monitors progress by displaying the number of rows processed", "so far on the terminal (standard error).", "This number is updated every second or thereabouts;", "if all the processing is done in under a second you may not", "see any output.", "If the total number of rows in the table is known,", "an ASCII-art progress bar is updated, otherwise just the", "number of rows seen so far is written."};
    }

    public ProcessingStep createStep(Iterator argIt) {
        return this;
    }

    public StarTable wrap(StarTable in) {
        return new ProgressLineStarTable(in, this.pstrm_);
    }
}

