/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.RandomRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class RandomFilter
extends BasicFilter
implements ProcessingStep {
    public RandomFilter() {
        super("random", null);
    }

    protected String[] getDescriptionLines() {
        return new String[]{"Ensures that steps downstream see the table as random access.", "Only useful for debugging."};
    }

    public ProcessingStep createStep(Iterator argIt) {
        return this;
    }

    public StarTable wrap(final StarTable base) throws IOException {
        if (base.isRandom()) {
            return new WrapperStarTable(base){

                public RowSequence getRowSequence() {
                    return new RandomRowSequence(base);
                }
            };
        }
        throw new IOException("Table is not random");
    }
}

