/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Arrays;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class ReplaceValueTable
extends WrapperStarTable {
    private static final Replacer unitReplacer_ = new Replacer(){

        public Object replaceValue(Object obj) {
            return obj;
        }
    };
    private static final double FLOAT_TOL = (double)2.8E-45f;
    private static final double DOUBLE_TOL = 9.9E-324;
    private final Replacer[] replacers_;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;

    public ReplaceValueTable(StarTable baseTable, boolean[] colFlags, String oldStr, String newStr) throws IOException {
        super(baseTable);
        int ncol = baseTable.getColumnCount();
        this.replacers_ = new Replacer[ncol];
        int i = 0;
        while (i < ncol) {
            this.replacers_[i] = colFlags[i] ? ReplaceValueTable.createReplacer(baseTable.getColumnInfo(i), oldStr, newStr) : unitReplacer_;
            ++i;
        }
    }

    public ReplaceValueTable(StarTable baseTable, int[] icols, String[] oldStrs, String[] newStrs) throws IOException {
        super(baseTable);
        int ncol = baseTable.getColumnCount();
        this.replacers_ = new Replacer[ncol];
        Arrays.fill(this.replacers_, unitReplacer_);
        int i = 0;
        while (i < icols.length) {
            int icol = icols[i];
            this.replacers_[icol] = ReplaceValueTable.createReplacer(baseTable.getColumnInfo(icol), oldStrs[i], newStrs[i]);
            ++i;
        }
    }

    public Object getCell(long irow, int icol) throws IOException {
        return this.replacers_[icol].replaceValue(super.getCell(irow, icol));
    }

    public Object[] getRow(long irow) throws IOException {
        Object[] row = super.getRow(irow);
        int icol = 0;
        while (icol < row.length) {
            row[icol] = this.replacers_[icol].replaceValue(row[icol]);
            ++icol;
        }
        return row;
    }

    public RowSequence getRowSequence() throws IOException {
        return new WrapperRowSequence(super.getRowSequence()){

            public Object getCell(int icol) throws IOException {
                return ReplaceValueTable.this.replacers_[icol].replaceValue(super.getCell(icol));
            }

            public Object[] getRow() throws IOException {
                Object[] row = super.getRow();
                int icol = 0;
                while (icol < row.length) {
                    row[icol] = ReplaceValueTable.this.replacers_[icol].replaceValue(row[icol]);
                    ++icol;
                }
                return row;
            }
        };
    }

    private static Replacer createReplacer(ColumnInfo info, String oldStr, String newStr) throws IOException {
        try {
            Object newValue;
            Class clazz = info.getContentClass();
            boolean oldBlank = Tables.isBlank(oldStr);
            boolean newBlank = Tables.isBlank(newStr);
            Object object = newValue = newBlank ? null : info.unformatString(newStr);
            if (oldBlank) {
                return new Replacer(){

                    public Object replaceValue(Object obj) {
                        return Tables.isBlank(obj) ? newValue : obj;
                    }
                };
            }
            if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ReplaceValueTable.class$("java.lang.Double")) : class$java$lang$Double)) {
                final double oldVal = Double.parseDouble(oldStr);
                return new Replacer(){

                    public Object replaceValue(Object obj) {
                        if (obj instanceof Double) {
                            double diff = (Double)obj - oldVal;
                            return Math.abs(diff) <= 9.9E-324 ? newValue : obj;
                        }
                        return obj;
                    }
                };
            }
            if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ReplaceValueTable.class$("java.lang.Float")) : class$java$lang$Float)) {
                final float oldVal = Float.parseFloat(oldStr);
                return new Replacer(){

                    public Object replaceValue(Object obj) {
                        if (obj instanceof Float) {
                            float diff = ((Float)obj).floatValue() - oldVal;
                            return (double)Math.abs(diff) <= (double)2.8E-45f ? newValue : obj;
                        }
                        return obj;
                    }
                };
            }
            final Object oldVal = info.unformatString(oldStr);
            return new Replacer(){

                public Object replaceValue(Object obj) {
                    return oldVal.equals(obj) ? newValue : obj;
                }
            };
        }
        catch (IllegalArgumentException e) {
            String msg = "Can't replace \"" + oldStr + "\" with \"" + newStr + "\" in " + ColumnInfo.formatClass(info.getContentClass()) + " column " + info.getName();
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static abstract class Replacer {
        private Replacer() {
        }

        public abstract Object replaceValue(Object var1);
    }
}

