/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import gnu.jel.CompilationException;
import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.JELSelectorTable;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class SelectFilter
extends BasicFilter {
    public SelectFilter() {
        super("select", "<expr>");
    }

    protected String[] getDescriptionLines() {
        return new String[]{"Include in the output table only rows for which the", "expression <code>&lt;expr&gt;</code> evaluates to true.", "<code>&lt;expr&gt;</code> must be an expression which", "evaluates to a boolean value (true/false)."};
    }

    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        if (argIt.hasNext()) {
            String expr = (String)argIt.next();
            argIt.remove();
            return new SelectStep(expr);
        }
        throw new ArgException("Missing expression");
    }

    private static class SelectStep
    implements ProcessingStep {
        final String expr_;

        public SelectStep(String expr) {
            this.expr_ = expr;
        }

        public StarTable wrap(StarTable base) throws IOException {
            try {
                return new JELSelectorTable(base, this.expr_);
            }
            catch (CompilationException e) {
                String msg = "Bad expression \"" + this.expr_ + "\" (" + e.getMessage() + ")";
                throw (IOException)new IOException(msg).initCause(e);
            }
        }
    }
}

