/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.LinkedList;
import uk.ac.starlink.table.IteratorRowSequence;
import uk.ac.starlink.table.RandomRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperStarTable;

public class TailTable
extends WrapperStarTable {
    private final long ntail_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$filter$TailTable;

    public TailTable(StarTable base, long ntail) {
        super(base);
        this.ntail_ = ntail;
    }

    public long getRowCount() {
        long nbase = super.getRowCount();
        return nbase >= 0L ? Math.min(this.ntail_, nbase) : -1L;
    }

    public Object getCell(long irow, int icol) throws IOException {
        return super.getCell(this.translateRow(irow), icol);
    }

    public Object[] getRow(long irow) throws IOException {
        return super.getRow(this.translateRow(irow));
    }

    private long translateRow(long irow) {
        return super.getRowCount() - this.getRowCount() + irow;
    }

    public RowSequence getRowSequence() throws IOException {
        if (this.isRandom()) {
            return new RandomRowSequence(this);
        }
        long nbase = super.getRowCount();
        RowSequence baseSeq = super.getRowSequence();
        if (nbase >= 0L) {
            long nskip = nbase - this.ntail_;
            long i = 0L;
            while (i < nskip && baseSeq.next()) {
                ++i;
            }
            return baseSeq;
        }
        LinkedList<Object[]> queue = new LinkedList<Object[]>();
        long size = 0L;
        while (baseSeq.next()) {
            queue.addLast(baseSeq.getRow());
            if (++size <= this.ntail_) continue;
            queue.removeFirst();
            --size;
        }
        if (!$assertionsDisabled && size > this.ntail_) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && size != (long)queue.size()) {
            throw new AssertionError();
        }
        return new IteratorRowSequence(queue.iterator());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$ttools$filter$TailTable == null ? (class$uk$ac$starlink$ttools$filter$TailTable = TailTable.class$("uk.ac.starlink.ttools.filter.TailTable")) : class$uk$ac$starlink$ttools$filter$TailTable).desiredAssertionStatus();
    }
}

