/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.pal.AngleDR;
import uk.ac.starlink.pal.Pal;

public class Coords {
    private static Pattern dmsPattern;
    private static Pattern hmsPattern;
    public static final double DEGREE = Math.PI / 180;
    public static final double HOUR = 0.2617993877991494;
    public static final double ARC_MINUTE = 2.908882086657216E-4;
    public static final double ARC_SECOND = 4.84813681109536E-6;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$func$Coords;

    private Coords() {
    }

    public static String radiansToDms(double rad) {
        return Coords.radiansToDms(rad, 0);
    }

    public static String radiansToDms(double rad, int secFig) {
        if (Double.isNaN(rad)) {
            return null;
        }
        double degrees = Coords.radiansToDegrees(rad);
        int sign = degrees >= 0.0 ? 1 : -1;
        double round = 1.388888888888889E-4 * (double)sign;
        int i = 0;
        while (i < secFig) {
            round *= 0.1;
            ++i;
        }
        degrees += round;
        int d = (int)(degrees *= (double)sign);
        double minutes = (degrees - (double)d) * 60.0;
        int m = (int)minutes;
        double seconds = (minutes - (double)m) * 60.0;
        return Coords.formatDms(sign == 1, d, m, seconds, secFig);
    }

    public static String radiansToHms(double rad) {
        return Coords.radiansToHms(rad, 0);
    }

    public static String radiansToHms(double rad, int secFig) {
        if (Double.isNaN(rad)) {
            return null;
        }
        double degrees = Coords.radiansToDegrees(rad);
        int sign = degrees >= 0.0 ? 1 : -1;
        double hours = degrees / 15.0;
        double round = 1.388888888888889E-4 * (double)sign;
        int i = 0;
        while (i < secFig) {
            round *= 0.1;
            ++i;
        }
        hours += round;
        int h = (int)(hours *= (double)sign);
        double minutes = (hours - (double)h) * 60.0;
        int m = (int)minutes;
        double seconds = (minutes - (double)m) * 60.0;
        return Coords.formatHms(sign == 1, h, m, seconds, secFig);
    }

    public static double dmsToRadians(String dms) {
        Matcher matcher = dmsPattern.matcher(dms);
        if (!matcher.matches()) {
            throw new NumberFormatException(dms + " not in deg:min:sec format");
        }
        return Coords.dmsToRadians(!"-".equals(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Double.parseDouble(matcher.group(4)));
    }

    public static double hmsToRadians(String hms) {
        Matcher matcher = hmsPattern.matcher(hms);
        if (!matcher.matches()) {
            throw new NumberFormatException(hms + " not in hour:min:sec format");
        }
        return Coords.hmsToRadians(!"-".equals(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Double.parseDouble(matcher.group(4)));
    }

    public static double dmsToRadians(double deg, double min, double sec) {
        if (min < 0.0 || min > 60.0 || (double)((int)min) != min) {
            throw new IllegalArgumentException("Minutes argument " + min + " must be an integer between 0 and 59");
        }
        if (sec < 0.0 || sec > 60.0) {
            throw new IllegalArgumentException("Seconds argument " + sec + " must be between 0 and 60");
        }
        return Coords.dmsToRadians(!Coords.isNegative(deg), (int)Math.abs(deg), (int)min, sec);
    }

    public static double hmsToRadians(double hour, double min, double sec) {
        if (min < 0.0 || min > 60.0 || (double)((int)min) != min) {
            throw new IllegalArgumentException("Minutes argument " + min + " must be an integer between 0 and 59");
        }
        if (sec < 0.0 || sec > 60.0) {
            throw new IllegalArgumentException("Seconds argument " + sec + " must be between 0 and 60");
        }
        return Coords.hmsToRadians(!Coords.isNegative(hour), (int)Math.abs(hour), (int)min, sec);
    }

    public static double skyDistance(double ra1, double dec1, double ra2, double dec2) {
        return Coords.haversineSeparationFormula(ra1, dec1, ra2, dec2);
    }

    public static double skyDistanceDegrees(double ra1, double dec1, double ra2, double dec2) {
        return Math.toDegrees(Coords.skyDistance(Math.toRadians(ra1), Math.toRadians(dec1), Math.toRadians(ra2), Math.toRadians(dec2)));
    }

    public static double hoursToRadians(double hours) {
        return Coords.degreesToRadians(hours * 15.0);
    }

    public static double degreesToRadians(double deg) {
        return Math.toRadians(deg);
    }

    public static double radiansToDegrees(double rad) {
        return Math.toDegrees(rad);
    }

    public static double raFK4toFK5(double raFK4, double decFK4) {
        return Coords.raFK4toFK5(raFK4, decFK4, 1950.0);
    }

    public static double decFK4toFK5(double raFK4, double decFK4) {
        return Coords.decFK4toFK5(raFK4, decFK4, 1950.0);
    }

    public static double raFK5toFK4(double raFK5, double decFK5) {
        return Coords.raFK5toFK4(raFK5, decFK5, 1950.0);
    }

    public static double decFK5toFK4(double raFK5, double decFK5) {
        return Coords.decFK5toFK4(raFK5, decFK5, 1950.0);
    }

    public static double raFK4toFK5(double raFK4, double decFK4, double bepoch) {
        return new Pal().Fk45z(new AngleDR(raFK4, decFK4), bepoch).getAlpha();
    }

    public static double decFK4toFK5(double raFK4, double decFK4, double bepoch) {
        return new Pal().Fk45z(new AngleDR(raFK4, decFK4), bepoch).getDelta();
    }

    public static double raFK5toFK4(double raFK5, double decFK5, double bepoch) {
        return new Pal().Fk54z(new AngleDR(raFK5, decFK5), bepoch).getAngle().getAlpha();
    }

    public static double decFK5toFK4(double raFK5, double decFK5, double bepoch) {
        return new Pal().Fk54z(new AngleDR(raFK5, decFK5), bepoch).getAngle().getDelta();
    }

    private static boolean isNegative(double value) {
        return (Double.doubleToLongBits(value) & Long.MIN_VALUE) != 0L;
    }

    private static double dmsToRadians(boolean positive, int deg, int min, double sec) {
        if (!$assertionsDisabled && deg < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && min < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(sec >= 0.0)) {
            throw new AssertionError();
        }
        double radians = Coords.degreesToRadians((double)deg + ((double)min + sec / 60.0) / 60.0);
        return positive ? radians : -1.0 * radians;
    }

    private static double hmsToRadians(boolean positive, int hour, int min, double sec) {
        return 15.0 * Coords.dmsToRadians(positive, hour, min, sec);
    }

    private static String formatDms(boolean positive, int deg, int min, double sec, int dp) {
        if (!$assertionsDisabled && deg < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && min < 0) {
            throw new AssertionError();
        }
        return SexFormat.getDmsFormat(dp).format(positive, deg, min, sec);
    }

    private static String formatHms(boolean positive, int hour, int min, double sec, int dp) {
        return SexFormat.getHmsFormat(dp).format(positive, hour, min, sec);
    }

    private static Pattern getSexPattern(String trail1, String trail2, String trail3) {
        return Pattern.compile(" *([+\\-]?) *([0-9]+) *" + trail1 + " *([0-9]+) *" + trail2 + " *([0-9]+\\.?[0-9]*) *" + trail3 + " *");
    }

    private static double haversineSeparationFormula(double ra1, double dec1, double ra2, double dec2) {
        double sr2;
        double sd2 = Math.sin(0.5 * (dec2 - dec1));
        double a = sd2 * sd2 + (sr2 = Math.sin(0.5 * (ra2 - ra1))) * sr2 * Math.cos(dec1) * Math.cos(dec2);
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return a < 1.0 ? 2.0 * Math.asin(Math.sqrt(a)) : Math.PI;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$ttools$func$Coords == null ? (class$uk$ac$starlink$ttools$func$Coords = Coords.class$("uk.ac.starlink.ttools.func.Coords")) : class$uk$ac$starlink$ttools$func$Coords).desiredAssertionStatus();
        dmsPattern = Coords.getSexPattern("[:d ]", "[:m' ]", "[s\"]?");
        hmsPattern = Coords.getSexPattern("[:h ]", "[:m' ]", "[s\"]?");
    }

    private static class SexFormat {
        private boolean useSign;
        private int sf1;
        private int dp3;
        private char[] buf;
        private static SexFormat[] hmsFormats = new SexFormat[0];
        private static SexFormat[] dmsFormats = new SexFormat[0];
        private static char[] digits0 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        private static char[] digitsLeading = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        private static char[] digitsMinus = new char[]{'-', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

        private SexFormat(boolean useSign, int dp3) {
            this.useSign = useSign;
            this.dp3 = dp3;
            if (dp3 < 0) {
                throw new IllegalArgumentException();
            }
            this.buf = new char[(useSign ? 1 : 0) + 2 + 6 + (dp3 > 0 ? 1 : 0) + dp3];
        }

        public String format(boolean positive, int f1, int f2, double f3) {
            if (f1 < 0 || f2 < 0 || f3 < 0.0) {
                throw new IllegalArgumentException("Can't be negative");
            }
            if (Double.isNaN(f3)) {
                return null;
            }
            int f3i = (int)f3;
            int pos = 0;
            if (this.useSign) {
                int sgnChar = positive ? 43 : 45;
                this.buf[pos++] = sgnChar;
            }
            this.buf[pos++] = digitsLeading[f1 / 10 % 10];
            this.buf[pos++] = digits0[f1 % 10];
            this.buf[pos++] = 58;
            this.buf[pos++] = digits0[f2 / 10 % 10];
            this.buf[pos++] = digits0[f2 % 10];
            this.buf[pos++] = 58;
            this.buf[pos++] = digits0[f3i / 10 % 10];
            this.buf[pos++] = digits0[f3i % 10];
            if (this.dp3 > 0) {
                this.buf[pos++] = 46;
                int i = 0;
                while (i < this.dp3) {
                    this.buf[pos++] = digits0[(int)(f3 *= 10.0) % 10];
                    ++i;
                }
            }
            return new String(this.buf);
        }

        public static SexFormat getHmsFormat(int dp) {
            int nf = hmsFormats.length;
            if (dp >= nf) {
                hmsFormats = new SexFormat[dp + 1];
                int i = 0;
                while (i <= dp) {
                    SexFormat.hmsFormats[i] = new SexFormat(false, i);
                    ++i;
                }
            }
            return hmsFormats[dp];
        }

        public static SexFormat getDmsFormat(int dp) {
            int nf = dmsFormats.length;
            if (dp >= nf) {
                dmsFormats = new SexFormat[dp + 1];
                int i = 0;
                while (i <= dp) {
                    SexFormat.dmsFormats[i] = new SexFormat(true, i);
                    ++i;
                }
            }
            return dmsFormats[dp];
        }
    }
}

