/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;

public class Formats {
    private static final ThreadLocal kitHolder_ = new ThreadLocal(){

        protected Object initialValue() {
            return new FormatKit();
        }
    };

    private Formats() {
    }

    public static String formatDecimal(double value, int dp) {
        return Formats.getDpFormat(dp).format(value);
    }

    public static String formatDecimal(double value, String format) {
        return Formats.getFormat(format).format(value);
    }

    private static DecimalFormat getFormat(String format) {
        Map fmap = Formats.getKit().fmap_;
        if (!fmap.containsKey(format)) {
            DecimalFormat dfmt;
            NumberFormat nfmt = NumberFormat.getInstance();
            if (nfmt instanceof DecimalFormat) {
                dfmt = (DecimalFormat)nfmt;
                dfmt.applyPattern(format);
            } else {
                dfmt = new DecimalFormat(format);
            }
            fmap.put(format, dfmt);
        }
        return (DecimalFormat)fmap.get(format);
    }

    private static DecimalFormat getDpFormat(int dp) {
        DecimalFormat[] dpFormats = Formats.getKit().dpFormats_;
        if (dp >= dpFormats.length) {
            Formats.getKit().dpFormats_ = dpFormats = new DecimalFormat[dp + 1];
            int i = 0;
            while (i < dp + 1) {
                String format = ".";
                int j = 0;
                while (j < i) {
                    format = format + "0";
                    ++j;
                }
                dpFormats[i] = Formats.getFormat(format);
                ++i;
            }
        }
        return dpFormats[dp];
    }

    private static FormatKit getKit() {
        return (FormatKit)kitHolder_.get();
    }

    private static class FormatKit {
        final Map fmap_ = new HashMap();
        DecimalFormat[] dpFormats_ = new DecimalFormat[0];

        private FormatKit() {
        }
    }
}

