/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.pal.Pal;

public class Times {
    private static final char DATE_SEP = 'T';
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String TIME_PATTERN = "HH:mm:ss";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final Pal pal = new Pal();
    private static final Pattern ISO_REGEX = Pattern.compile("([0-9]+)-([0-9]{1,2})-([0-9]{1,2})(?:[T ]([0-9]{1,2})(?::([0-9]{1,2})(?::([0-9]{1,2}(?:\\.[0-9]*)?))?)?Z?)?");
    private static final double MJD_EPOCH = 40587.0;
    private static final double MILLIS_PER_DAY = 8.64E7;
    private static final ThreadLocal kitHolder_ = new ThreadLocal(){

        protected Object initialValue() {
            return new DateKit();
        }
    };

    private Times() {
    }

    public static double isoToMjd(String isoDate) {
        if (isoDate == null || isoDate.trim().length() == 0) {
            return Double.NaN;
        }
        Matcher matcher = ISO_REGEX.matcher(isoDate);
        if (matcher.matches()) {
            try {
                String[] groups = new String[6];
                int ng = matcher.groupCount();
                int i = 0;
                while (i < ng) {
                    groups[i] = matcher.group(i + 1);
                    ++i;
                }
                int year = Integer.parseInt(groups[0]);
                int month = Integer.parseInt(groups[1]);
                int dom = Integer.parseInt(groups[2]);
                int hour = groups[3] == null ? 0 : Integer.parseInt(groups[3]);
                int min = groups[4] == null ? 0 : Integer.parseInt(groups[4]);
                double sec = groups[5] == null ? 0.0 : Double.parseDouble(groups[5]);
                return Times.dateToMjd(year, month, dom, hour, min, sec);
            }
            catch (NumberFormatException e) {
                throw (IllegalArgumentException)new IllegalArgumentException("Bad ISO-8601 date " + isoDate).initCause(e);
            }
        }
        throw new IllegalArgumentException("Bad ISO-8601 date " + isoDate);
    }

    public static double dateToMjd(int year, int month, int day, int hour, int min, double sec) {
        Calendar cal = Times.getKit().calendar_;
        cal.clear();
        int intMillis = (int)Math.round(sec * 1000.0);
        cal.set(year, month - 1, day, hour, min, intMillis / 1000);
        cal.set(14, intMillis % 1000);
        return Times.unixMillisToMjd(cal.getTimeInMillis());
    }

    public static double dateToMjd(int year, int month, int day) {
        Calendar cal = Times.getKit().calendar_;
        cal.clear();
        cal.set(year, month - 1, day);
        return Times.unixMillisToMjd(cal.getTimeInMillis());
    }

    public static String mjdToIso(double mjd) {
        return Times.formatMjd(mjd, Times.getKit().isoDateTimeFormat_);
    }

    public static String mjdToDate(double mjd) {
        return Times.formatMjd(mjd, Times.getKit().isoDateFormat_);
    }

    public static String mjdToTime(double mjd) {
        return Times.formatMjd(mjd, Times.getKit().isoTimeFormat_);
    }

    public static String formatMjd(double mjd, String format) {
        return Times.formatMjd(mjd, Times.getFormat(format));
    }

    public static double mjdToJulian(double mjd) {
        return pal.Epj(mjd);
    }

    public static double julianToMjd(double julianEpoch) {
        return pal.Epj2d(julianEpoch);
    }

    public static double mjdToBesselian(double mjd) {
        return pal.Epb(mjd);
    }

    public static double besselianToMjd(double besselianEpoch) {
        return pal.Epb2d(besselianEpoch);
    }

    static int mjdYear(double mjd) {
        return Times.getField(mjd, 1);
    }

    static int mjdMonth(double mjd) {
        return Times.getField(mjd, 2) + 1;
    }

    static int mjdDayOfMonth(double mjd) {
        return Times.getField(mjd, 5);
    }

    static int mjdHour(double mjd) {
        return Times.getField(mjd, 11);
    }

    static int mjdMinute(double mjd) {
        return Times.getField(mjd, 12);
    }

    static double mjdSecond(double mjd) {
        double minutes = mjd * 60.0 * 24.0;
        double minFrac = minutes - Math.floor(minutes);
        return minFrac * 60.0;
    }

    private static int getField(double mjd, int field) {
        Calendar cal = Times.getKit().calendar_;
        cal.setTimeInMillis(Times.mjdToUnixMillis(mjd));
        return cal.get(field);
    }

    private static String formatMjd(double mjd, DateFormat format) {
        if (Double.isNaN(mjd) || Double.isInfinite(mjd)) {
            return null;
        }
        return format.format(new Date(Times.mjdToUnixMillis(mjd)));
    }

    private static double unixMillisToMjd(long unixMillis) {
        return (double)unixMillis / 8.64E7 + 40587.0;
    }

    private static long mjdToUnixMillis(double mjd) {
        return Math.round((mjd - 40587.0) * 8.64E7);
    }

    private static DateKit getKit() {
        return (DateKit)kitHolder_.get();
    }

    private static DateFormat getFormat(String pattern) {
        Map map = Times.getKit().patternMap_;
        if (!map.containsKey(pattern)) {
            map.put(pattern, Times.newDateFormat(pattern));
        }
        return (DateFormat)map.get(pattern);
    }

    private static Calendar newCalendar() {
        GregorianCalendar cal = new GregorianCalendar(UTC, Locale.UK);
        cal.setLenient(false);
        return cal;
    }

    private static DateFormat newDateFormat(String pattern) {
        SimpleDateFormat fmt = new SimpleDateFormat(pattern);
        fmt.setTimeZone(UTC);
        fmt.setCalendar(Times.newCalendar());
        return fmt;
    }

    static /* synthetic */ Calendar access$100() {
        return Times.newCalendar();
    }

    static /* synthetic */ DateFormat access$200(String x0) {
        return Times.newDateFormat(x0);
    }

    private static class DateKit {
        final Calendar calendar_ = Times.access$100();
        final Map patternMap_ = new HashMap();
        final DateFormat isoDateTimeFormat_ = Times.access$200("yyyy-MM-dd'T'HH:mm:ss");
        final DateFormat isoDateFormat_ = Times.access$200("yyyy-MM-dd");
        final DateFormat isoTimeFormat_ = Times.access$200("HH:mm:ss");

        private DateKit() {
        }
    }
}

