/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.lint;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import uk.ac.starlink.ttools.lint.FieldHandler;
import uk.ac.starlink.ttools.lint.StreamingHandler;
import uk.ac.starlink.ttools.lint.ValueParser;

public class BinaryHandler
extends StreamingHandler {
    public void feed(InputStream in) throws IOException {
        FieldHandler[] fields = this.getFields();
        int ncol = fields.length;
        ValueParser[] parsers = new ValueParser[ncol];
        int icol = 0;
        while (icol < ncol) {
            parsers[icol] = fields[icol].getParser();
            if (parsers[icol] == null) {
                this.warning("Can't validate stream with unidentified column " + fields[icol]);
                throw new IOException("No stream validation");
            }
            ++icol;
        }
        PushbackInputStream pushIn = new PushbackInputStream(in);
        int b;
        while ((b = pushIn.read()) >= 0) {
            pushIn.unread(b);
            int icol2 = 0;
            while (icol2 < ncol) {
                parsers[icol2].checkStream(pushIn);
                ++icol2;
            }
            this.foundRow();
        }
        return;
    }
}

