/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.lint;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import uk.ac.starlink.ttools.lint.LintContentHandler;
import uk.ac.starlink.ttools.lint.LintContext;
import uk.ac.starlink.ttools.lint.LintEntityResolver;
import uk.ac.starlink.util.StarEntityResolver;

public class Linter {
    private final LintContext context_;

    public Linter(LintContext context) {
        this.context_ = context;
    }

    public XMLReader createParser(boolean validate) throws SAXException {
        XMLReader parser;
        try {
            SAXParserFactory spfact = SAXParserFactory.newInstance();
            spfact.setValidating(validate);
            spfact.setNamespaceAware(true);
            parser = spfact.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw (SAXException)new SAXException(e.getMessage()).initCause(e);
        }
        LintEntityResolver entityResolver = new LintEntityResolver(this.context_);
        try {
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", entityResolver);
            parser.setEntityResolver(entityResolver);
        }
        catch (SAXException e) {
            parser.setEntityResolver(StarEntityResolver.getInstance());
            this.context_.warning("Entity trouble - DTD validation may not be done properly (" + e + ")");
        }
        LintContentHandler lintHandler = new LintContentHandler(this.context_);
        parser.setContentHandler(lintHandler);
        parser.setErrorHandler(lintHandler);
        return parser;
    }
}

