/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.lint;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.StringTokenizer;
import uk.ac.starlink.ttools.lint.ElementHandler;
import uk.ac.starlink.ttools.lint.LintContext;

public abstract class ValueParser {
    private LintContext context_;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$lint$ValueParser;

    public abstract void checkString(String var1);

    public abstract void checkStream(InputStream var1) throws IOException;

    public abstract Class getContentClass();

    public abstract int getElementCount();

    public void setContext(LintContext context) {
        this.context_ = context;
    }

    public LintContext getContext() {
        return this.context_;
    }

    public void info(String msg) {
        this.getContext().info(msg);
    }

    public void warning(String msg) {
        this.getContext().warning(msg);
    }

    public void error(String msg) {
        this.getContext().error(msg);
    }

    public static ValueParser makeParser(ElementHandler handler, String datatype, String arraysize) {
        int i;
        int[] shape;
        if (datatype == null || datatype.trim().length() == 0) {
            handler.error("No datatype specified for " + handler + " Can't parse values");
            return null;
        }
        if (arraysize == null || arraysize.trim().length() == 0) {
            shape = new int[]{1};
            if ("char".equals(datatype) || "unicodeChar".equals(datatype)) {
                handler.info("No arraysize for character, " + handler + " implies single character");
            }
        } else {
            String[] dims = arraysize.split("x");
            shape = new int[dims.length];
            i = 0;
            while (i < dims.length) {
                if (i == dims.length - 1 && dims[i].endsWith("*")) {
                    String num = dims[i].substring(0, dims[i].length() - 1);
                    if (num.length() > 0) {
                        try {
                            Integer.parseInt(num);
                        }
                        catch (NumberFormatException e) {
                            handler.error("Bad arraysize value '" + arraysize + "'");
                        }
                    }
                    shape[i] = -1;
                } else {
                    try {
                        shape[i] = Integer.parseInt(dims[i]);
                    }
                    catch (NumberFormatException e) {
                        handler.error("Bad arraysize value '" + arraysize + "'");
                        return null;
                    }
                    if (shape[i] <= 0) {
                        handler.error("Non-positive dimensions element " + shape[i]);
                        return null;
                    }
                }
                ++i;
            }
        }
        int nel = 1;
        i = 0;
        while (i < shape.length) {
            nel *= shape[i];
            ++i;
        }
        if ("char".equals(datatype) || "unicodeChar".equals(datatype)) {
            boolean ascii = "char".equals(datatype);
            int stringLeng = shape[0];
            if (nel == 1) {
                return new SingleCharParser(ascii);
            }
            if (shape.length == 1) {
                if (stringLeng < 0) {
                    return new VariableCharParser(ascii);
                }
                return new FixedCharParser(ascii, stringLeng);
            }
            if (nel < 0) {
                return new VariableStringArrayParser(ascii, stringLeng);
            }
            int nString = nel / stringLeng;
            return new FixedArrayParser(new FixedCharParser(ascii, stringLeng), array$Ljava$lang$String == null ? (array$Ljava$lang$String = ValueParser.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, nString);
        }
        if ("bit".equals(datatype)) {
            if (nel < 0) {
                return new VariableBitParser();
            }
            return new FixedBitParser(nel);
        }
        if ("floatComplex".equals(datatype)) {
            if (nel < 0) {
                return new VariableArrayParser(new FloatParser(), array$F == null ? (array$F = ValueParser.class$("[F")) : array$F);
            }
            return new FixedArrayParser(new FloatParser(), array$F == null ? (array$F = ValueParser.class$("[F")) : array$F, nel * 2);
        }
        if ("doubleComplex".equals(datatype)) {
            if (nel < 0) {
                return new VariableArrayParser(new DoubleParser(), array$D == null ? (array$D = ValueParser.class$("[D")) : array$D);
            }
            return new FixedArrayParser(new DoubleParser(), array$D == null ? (array$D = ValueParser.class$("[D")) : array$D, nel * 2);
        }
        if (nel == 1) {
            return ValueParser.makeScalarParser(datatype, handler);
        }
        ValueParser base = ValueParser.makeScalarParser(datatype, handler);
        if (base == null) {
            return null;
        }
        Class clazz = ValueParser.getArrayClass(base.getContentClass());
        return nel < 0 ? new VariableArrayParser(base, clazz) : new FixedArrayParser(base, clazz, nel);
    }

    private static ValueParser makeScalarParser(String datatype, ElementHandler handler) {
        if ("boolean".equals(datatype)) {
            return new BooleanParser();
        }
        if ("unsignedByte".equals(datatype)) {
            return new IntegerParser(1, 0L, 255L, class$java$lang$Short == null ? (class$java$lang$Short = ValueParser.class$("java.lang.Short")) : class$java$lang$Short);
        }
        if ("short".equals(datatype)) {
            return new IntegerParser(2, -32768L, 32767L, class$java$lang$Short == null ? (class$java$lang$Short = ValueParser.class$("java.lang.Short")) : class$java$lang$Short);
        }
        if ("int".equals(datatype)) {
            return new IntegerParser(4, Integer.MIN_VALUE, Integer.MAX_VALUE, class$java$lang$Integer == null ? (class$java$lang$Integer = ValueParser.class$("java.lang.Integer")) : class$java$lang$Integer);
        }
        if ("long".equals(datatype)) {
            return new IntegerParser(8, Long.MIN_VALUE, Long.MAX_VALUE, class$java$lang$Long == null ? (class$java$lang$Long = ValueParser.class$("java.lang.Long")) : class$java$lang$Long);
        }
        if ("float".equals(datatype)) {
            return new FloatParser();
        }
        if ("double".equals(datatype)) {
            return new DoubleParser();
        }
        handler.error("Unknown datatype '" + datatype + "'" + " - can't parse column");
        return null;
    }

    void slurpStream(InputStream in, int nbyte) throws IOException {
        int i = 0;
        while (i < nbyte) {
            if (in.read() < 0) {
                this.error("Stream ended during data read");
                throw new EOFException();
            }
            ++i;
        }
    }

    int readCount(InputStream in) throws IOException {
        int c1 = in.read();
        int c2 = in.read();
        int c3 = in.read();
        int c4 = in.read();
        if (c1 < 0 || c2 < 0 || c3 < 0 || c4 < 0) {
            this.error("End of stream while reading element count (probable stream corruption)");
            throw new EOFException();
        }
        int count = (c1 & 0xFF) << 24 | (c2 & 0xFF) << 16 | (c3 & 0xFF) << 8 | (c4 & 0xFF) << 0;
        if (count < 0) {
            this.error("Apparent negative element count (probably stream corruption)");
            throw new IOException("Unrecoverable stream error");
        }
        return count;
    }

    private static Class getArrayClass(Class wclazz) {
        if (wclazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ValueParser.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return array$Z == null ? (array$Z = ValueParser.class$("[Z")) : array$Z;
        }
        if (wclazz == (class$java$lang$Character == null ? (class$java$lang$Character = ValueParser.class$("java.lang.Character")) : class$java$lang$Character)) {
            return array$C == null ? (array$C = ValueParser.class$("[C")) : array$C;
        }
        if (wclazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = ValueParser.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return array$B == null ? (array$B = ValueParser.class$("[B")) : array$B;
        }
        if (wclazz == (class$java$lang$Short == null ? (class$java$lang$Short = ValueParser.class$("java.lang.Short")) : class$java$lang$Short)) {
            return array$S == null ? (array$S = ValueParser.class$("[S")) : array$S;
        }
        if (wclazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = ValueParser.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return array$I == null ? (array$I = ValueParser.class$("[I")) : array$I;
        }
        if (wclazz == (class$java$lang$Long == null ? (class$java$lang$Long = ValueParser.class$("java.lang.Long")) : class$java$lang$Long)) {
            return array$J == null ? (array$J = ValueParser.class$("[J")) : array$J;
        }
        if (wclazz == (class$java$lang$Float == null ? (class$java$lang$Float = ValueParser.class$("java.lang.Float")) : class$java$lang$Float)) {
            return array$F == null ? (array$F = ValueParser.class$("[F")) : array$F;
        }
        if (wclazz == (class$java$lang$Double == null ? (class$java$lang$Double = ValueParser.class$("java.lang.Double")) : class$java$lang$Double)) {
            return array$D == null ? (array$D = ValueParser.class$("[D")) : array$D;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return Array.newInstance(wclazz, 0).getClass();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$ttools$lint$ValueParser == null ? (class$uk$ac$starlink$ttools$lint$ValueParser = ValueParser.class$("uk.ac.starlink.ttools.lint.ValueParser")) : class$uk$ac$starlink$ttools$lint$ValueParser).desiredAssertionStatus();
    }

    private static class VariableStringArrayParser
    extends AbstractParser {
        final boolean ascii_;
        final int stringLeng_;

        VariableStringArrayParser(boolean ascii, int stringLeng) {
            super(array$Ljava$lang$String == null ? (array$Ljava$lang$String = ValueParser.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, -1);
            this.ascii_ = ascii;
            this.stringLeng_ = stringLeng;
        }

        public void checkString(String text) {
            StringTokenizer stok = new StringTokenizer(text);
            while (stok.hasMoreTokens()) {
                String item = stok.nextToken();
                if (item.length() <= this.stringLeng_) continue;
                this.warning("String " + item + " longer than declared " + "maximum length");
            }
        }

        public void checkStream(InputStream in) throws IOException {
            this.slurpStream(in, this.readCount(in) * (this.ascii_ ? 1 : 2));
        }
    }

    private static class VariableCharParser
    extends AbstractParser {
        final boolean ascii_;

        VariableCharParser(boolean ascii) {
            super(class$java$lang$String == null ? (class$java$lang$String = ValueParser.class$("java.lang.String")) : class$java$lang$String, 1);
            this.ascii_ = ascii;
        }

        public void checkString(String text) {
        }

        public void checkStream(InputStream in) throws IOException {
            this.slurpStream(in, this.readCount(in) * (this.ascii_ ? 1 : 2));
        }
    }

    private static class FixedCharParser
    extends SlurpParser {
        public FixedCharParser(boolean ascii, int count) {
            super(count * (ascii ? 1 : 2), class$java$lang$String == null ? (class$java$lang$String = ValueParser.class$("java.lang.String")) : class$java$lang$String, 1);
        }

        public void checkString(String text) {
        }
    }

    private static class SingleCharParser
    extends SlurpParser {
        private final boolean ascii_;

        public SingleCharParser(boolean ascii) {
            super(ascii ? 1 : 2, class$java$lang$Character == null ? (class$java$lang$Character = ValueParser.class$("java.lang.Character")) : class$java$lang$Character, 1);
            this.ascii_ = ascii;
        }

        public void checkString(String text) {
            int leng = text.length();
            switch (leng) {
                case 0: {
                    this.warning("Empty character value is questionable");
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    this.warning("Characters after first in char scalar ignored (missing arraysize?)");
                }
            }
            if (this.ascii_ && leng > 0 && text.charAt(0) > '\u007f') {
                this.error("Non-ascii character in 'char' data");
            }
        }
    }

    private static class VariableBitParser
    extends AbstractParser {
        public VariableBitParser() {
            super(array$Z == null ? (array$Z = ValueParser.class$("[Z")) : array$Z, -1);
        }

        public void checkString(String text) {
            int leng = text.length();
            int i = 0;
            while (i < leng) {
                switch (text.charAt(i)) {
                    case '\n': 
                    case ' ': 
                    case '0': 
                    case '1': {
                        break;
                    }
                    default: {
                        this.error("Bad value for bit vector " + text);
                        return;
                    }
                }
                ++i;
            }
        }

        public void checkStream(InputStream in) throws IOException {
            this.slurpStream(in, (1 + this.readCount(in)) / 8);
        }
    }

    private static class FixedBitParser
    extends SlurpParser {
        final int count_;

        FixedBitParser(int count) {
            super((count + 7) / 8, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ValueParser.class$("java.lang.Boolean")) : class$java$lang$Boolean, count);
            this.count_ = count;
        }

        public void checkString(String text) {
            int leng = text.length();
            int nbit = 0;
            int i = 0;
            while (i < leng) {
                switch (text.charAt(i)) {
                    case '0': 
                    case '1': {
                        ++nbit;
                        break;
                    }
                    case '\n': 
                    case ' ': {
                        break;
                    }
                    default: {
                        this.error("Bad value for bit vector " + text);
                        return;
                    }
                }
                ++i;
            }
            if (nbit != this.count_) {
                this.error("Wrong number of elements in array (" + nbit + " found, " + this.count_ + " expected)");
            }
        }
    }

    private static class DoubleParser
    extends SlurpParser {
        DoubleParser() {
            super(8, class$java$lang$Double == null ? (class$java$lang$Double = ValueParser.class$("java.lang.Double")) : class$java$lang$Double, 1);
        }

        public void checkString(String text) {
            if ("NaN".equals(text) || "+Inf".equals(text) || "-Inf".equals(text) || text.trim().length() == 0) {
                return;
            }
            try {
                Double.parseDouble(text);
            }
            catch (NumberFormatException e) {
                this.error("Bad double string " + text);
            }
        }
    }

    private static class FloatParser
    extends SlurpParser {
        FloatParser() {
            super(4, class$java$lang$Float == null ? (class$java$lang$Float = ValueParser.class$("java.lang.Float")) : class$java$lang$Float, 1);
        }

        public void checkString(String text) {
            if ("NaN".equals(text) || "+Inf".equals(text) || "-Inf".equals(text) || text.trim().length() == 0) {
                return;
            }
            try {
                Float.parseFloat(text);
            }
            catch (NumberFormatException e) {
                this.error("Bad float string " + text);
            }
        }
    }

    private static class IntegerParser
    extends SlurpParser {
        final long minVal_;
        final long maxVal_;

        IntegerParser(int nbyte, long minVal, long maxVal, Class clazz) {
            super(nbyte, clazz, 1);
            this.minVal_ = minVal;
            this.maxVal_ = maxVal;
        }

        public void checkString(String text) {
            long value;
            int pos = 0;
            int leng = text.length();
            while (pos < leng && text.charAt(pos) == ' ') {
                ++pos;
            }
            if (leng - pos > 1 && text.charAt(pos + 1) == 'x' && text.charAt(pos) == '0') {
                try {
                    value = Long.parseLong(text.substring(pos + 2), 16);
                }
                catch (NumberFormatException e) {
                    this.error("Bad hexadecimal string '" + text + "'");
                    return;
                }
            }
            if (text.trim().length() == 0) {
                this.error("Empty cell illegal for integer value");
                return;
            }
            try {
                value = Long.parseLong(text);
            }
            catch (NumberFormatException e) {
                this.error("Bad integer string '" + text + "'");
                return;
            }
            if (value < this.minVal_ || value > this.maxVal_) {
                this.error("Value " + text + " outside type range " + this.minVal_ + "..." + this.maxVal_);
            }
        }
    }

    private static class BooleanParser
    extends AbstractParser {
        public BooleanParser() {
            super(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ValueParser.class$("java.lang.Boolean")) : class$java$lang$Boolean, 1);
        }

        public void checkString(String text) {
            int leng = text.length();
            if (leng == 0) {
                return;
            }
            if (leng == 1) {
                switch (text.charAt(0)) {
                    case '\u0000': 
                    case ' ': 
                    case '0': 
                    case '1': 
                    case '?': 
                    case 'F': 
                    case 'T': 
                    case 'f': 
                    case 't': {
                        return;
                    }
                }
                this.error("Bad boolean value '" + text + "'");
            } else {
                if (text.equalsIgnoreCase("true") || text.equalsIgnoreCase("false")) {
                    return;
                }
                this.error("Bad boolean value '" + text + "'");
            }
        }

        public void checkStream(InputStream in) throws IOException {
            char chr = (char)(0xFFFF & in.read());
            switch (chr) {
                case '\u0000': 
                case ' ': 
                case '0': 
                case '1': 
                case '?': 
                case 'F': 
                case 'T': 
                case 'f': 
                case 't': {
                    return;
                }
                case '\uffff': {
                    this.error("End of stream during read");
                    throw new EOFException();
                }
            }
            this.error("Bad boolean value '" + chr + "'");
        }
    }

    private static class VariableArrayParser
    extends AbstractParser {
        final ValueParser base_;

        VariableArrayParser(ValueParser base, Class clazz) {
            super(clazz, -1);
            this.base_ = base;
            this.base_.toString();
        }

        public LintContext getContext() {
            return this.base_.getContext();
        }

        public void setContext(LintContext context) {
            this.base_.setContext(context);
        }

        public void checkString(String text) {
            StringTokenizer stok = new StringTokenizer(text);
            while (stok.hasMoreTokens()) {
                this.base_.checkString(stok.nextToken());
            }
        }

        public void checkStream(InputStream in) throws IOException {
            int count = this.readCount(in);
            int i = 0;
            while (i < count) {
                try {
                    this.base_.checkStream(in);
                }
                catch (EOFException e) {
                    this.error("End of stream while reading " + count + " elements (probable stream corruption)");
                    throw e;
                }
                ++i;
            }
        }
    }

    private static class FixedArrayParser
    extends AbstractParser {
        final ValueParser base_;
        final int count_;

        FixedArrayParser(ValueParser base, Class clazz, int count) {
            super(clazz, count);
            this.base_ = base;
            this.count_ = count;
            this.base_.toString();
        }

        public LintContext getContext() {
            return this.base_.getContext();
        }

        public void setContext(LintContext context) {
            this.base_.setContext(context);
        }

        public void checkString(String text) {
            StringTokenizer stok = new StringTokenizer(text);
            int ntok = stok.countTokens();
            if (ntok != this.count_) {
                this.error("Wrong number of elements in array (" + ntok + " found, " + this.count_ + " expected)");
            }
            while (stok.hasMoreTokens()) {
                this.base_.checkString(stok.nextToken());
            }
        }

        public void checkStream(InputStream in) throws IOException {
            int i = 0;
            while (i < this.count_) {
                this.base_.checkStream(in);
                ++i;
            }
        }
    }

    private static abstract class SlurpParser
    extends ValueParser {
        private final int nbyte_;
        private final Class clazz_;
        private final int count_;

        SlurpParser(int nbyte, Class clazz, int count) {
            this.nbyte_ = nbyte;
            this.clazz_ = clazz;
            this.count_ = count;
        }

        public Class getContentClass() {
            return this.clazz_;
        }

        public int getElementCount() {
            return this.count_;
        }

        public void checkStream(InputStream in) throws IOException {
            this.slurpStream(in, this.nbyte_);
        }
    }

    private static abstract class AbstractParser
    extends ValueParser {
        private final Class clazz_;
        private final int count_;

        public AbstractParser(Class clazz, int count) {
            this.clazz_ = clazz;
            this.count_ = count;
        }

        public Class getContentClass() {
            return this.clazz_;
        }

        public int getElementCount() {
            return this.count_;
        }
    }
}

