/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.io.IOException;
import java.sql.SQLException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.jdbc.JDBCHandler;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.task.TableEnvironment;

public class JdbcConsumer
implements TableConsumer {
    private final String url_;
    private final JDBCHandler handler_;

    public JdbcConsumer(String url, JDBCHandler handler) {
        this.url_ = url;
        this.handler_ = handler;
    }

    public JdbcConsumer(String url, Environment env) {
        this(url, new JDBCHandler(TableEnvironment.getJdbcAuthenticator(env)));
    }

    public void consume(StarTable table) throws IOException {
        try {
            this.handler_.createJDBCTable(table, this.url_);
        }
        catch (SQLException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = "SQL error";
            }
            throw (IOException)new IOException(msg).initCause(e);
        }
    }
}

