/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.util.logging.Logger;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.table.jdbc.JDBCHandler;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.JdbcConsumer;
import uk.ac.starlink.ttools.mode.ProcessingMode;

public class JdbcMode
implements ProcessingMode {
    private final Parameter protoParam_ = new Parameter("protocol");
    private final Parameter hostParam_;
    private final Parameter dbParam_;
    private final Parameter tableParam_;
    private final Parameter userParam_;
    private final Parameter passwdParam_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.jdbc");

    public JdbcMode() {
        this.protoParam_.setPrompt("Subprotocol for JDBC connection (e.g. mysql)");
        this.protoParam_.setUsage("<jdbc-protocol>");
        this.protoParam_.setDescription(new String[]{"The driver-specific sub-protocol specifier for the JDBC", "connection.", "For MySQL's Connector/J driver, this is <code>mysql</code>,", "and for PostgreSQL's driver it is <code>postgres</code>.", "For other drivers, you may have to consult the driver", "documentation."});
        this.hostParam_ = new Parameter("host");
        this.hostParam_.setPrompt("SQL database host");
        this.hostParam_.setPrompt("<hostname>");
        this.hostParam_.setDefault("localhost");
        this.hostParam_.setDescription(new String[]{"The host which is acting as a database server."});
        this.dbParam_ = new Parameter("database");
        this.dbParam_.setPrompt("Name of database on database server");
        this.dbParam_.setUsage("<db-name>");
        this.dbParam_.setDescription(new String[]{"The name of the database on the server into which the", "new table will be written."});
        this.tableParam_ = new Parameter("newtable");
        this.tableParam_.setPrompt("Name of new table to write to database");
        this.tableParam_.setUsage("<table-name>");
        this.tableParam_.setDescription(new String[]{"The name of the new table which will be written to the", "database.", "If a table by this name already exists, it may be overwritten."});
        this.userParam_ = new Parameter("user");
        this.userParam_.setPrompt("Username for SQL connection");
        this.userParam_.setUsage("<username>");
        this.userParam_.setNullPermitted(true);
        this.userParam_.setPreferExplicit(true);
        try {
            this.userParam_.setDefault(System.getProperty("user.name"));
        }
        catch (SecurityException e) {
            // empty catch block
        }
        this.userParam_.setDescription(new String[]{"User name for the SQL connection to the database."});
        this.passwdParam_ = new Parameter("password");
        this.passwdParam_.setPrompt("Password for SQL connection");
        this.passwdParam_.setUsage("<passwd>");
        this.passwdParam_.setNullPermitted(true);
        this.passwdParam_.setPreferExplicit(true);
        this.passwdParam_.setDescription(new String[]{"Password for the SQL connection to the database."});
    }

    public Parameter[] getAssociatedParameters() {
        return new Parameter[]{this.protoParam_, this.hostParam_, this.dbParam_, this.tableParam_, this.userParam_, this.passwdParam_};
    }

    public String getDescription() {
        return "Writes a new table to an SQL database.\n" + "You need the appropriate JDBC drivers and\n" + "<code>-Djdcb.drivers</code> set as usual\n" + "(see <ref id=\"jdbcConfig\"/>).\n";
    }

    public TableConsumer createConsumer(Environment env) throws TaskException {
        String url = "jdbc:" + this.protoParam_.stringValue(env) + "://" + this.hostParam_.stringValue(env) + "/" + this.dbParam_.stringValue(env) + "#" + this.tableParam_.stringValue(env);
        logger_.info("JDBC URL: " + url);
        final String user = this.userParam_.stringValue(env);
        final String passwd = this.passwdParam_.stringValue(env);
        JDBCAuthenticator auth = new JDBCAuthenticator(){

            public String[] authenticate() {
                return new String[]{user, passwd};
            }
        };
        return new JdbcConsumer(url, new JDBCHandler(auth));
    }
}

