/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.ProcessingMode;

public class MetadataMode
implements ProcessingMode {
    public Parameter[] getAssociatedParameters() {
        return new Parameter[0];
    }

    public String getDescription() {
        return "Prints the table metadata to standard output.\n" + "The name and type etc of each column is tabulated,\n" + "and table parameters are also shown.\n";
    }

    public TableConsumer createConsumer(Environment env) {
        final PrintStream out = env.getOutputStream();
        return new TableConsumer(){

            public void consume(StarTable table) {
                MetadataMode.this.reportMetadata(out, table);
            }
        };
    }

    private void reportMetadata(PrintStream out, StarTable table) {
        long nrow = table.getRowCount();
        int ncol = table.getColumnCount();
        String name = table.getName();
        out.println();
        if (name != null && name.trim().length() > 0) {
            out.println("Name:    " + name.trim());
        }
        out.println("Columns: " + new Integer(ncol));
        out.println("Rows:    " + (nrow >= 0L ? Long.toString(nrow) : "?"));
        List params = table.getParameters();
        if (params.size() > 0) {
            out.println();
            out.println("Parameters");
            out.println("----------");
            Iterator it = table.getParameters().iterator();
            while (it.hasNext()) {
                DescribedValue param = (DescribedValue)it.next();
                this.outMeta(out, param.getInfo().getName(), param.getValue());
            }
        }
        out.println();
        out.println("Columns");
        out.println("-------");
        ColumnInfo[] cinfos = Tables.getColumnInfos(table);
        int icol = 0;
        while (icol < ncol) {
            String scol = Integer.toString(icol + 1);
            int i = scol.length();
            while (i < 6) {
                out.print(' ');
                ++i;
            }
            out.print(scol + ": ");
            ColumnInfo cinfo = cinfos[icol];
            String text = cinfo.toString();
            String desc = cinfo.getDescription();
            if (desc != null) {
                text = text + " - " + desc;
            }
            out.println(text);
            ++icol;
        }
    }

    private void outMeta(PrintStream out, String key, Object val) {
        String value;
        String pad = "    ";
        if (val != null && (value = val.toString().trim()).length() > 0) {
            out.println(key + ":");
            value = pad + value.replaceAll("\n", pad + "\n");
            out.println(value);
        }
    }
}

