/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.rmi.RemoteException;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import uk.ac.starlink.soap.util.RemoteUtilities;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.votable.soap.VOTableSerialization;

public class TopcatMode
implements ProcessingMode,
TableConsumer {
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$uk$ac$starlink$soap$util$RemoteUtilities;
    static /* synthetic */ Class class$org$apache$axis$encoding$Target;

    public Parameter[] getAssociatedParameters() {
        return new Parameter[0];
    }

    public String getDescription() {
        return "Displays the output table directly in\n" + "<webref url=\"http://www.starlink.ac.uk/topcat/\"\n" + ">TOPCAT</webref>.\n" + "If a TOPCAT instance (version 1.6 or later) is already\n" + "running on the local host, the table will be opened in\n" + "that, otherwise a new TOPCAT instance will be launched\n" + "for display.\n" + "The latter mode only works if the TOPCAT classes are\n" + "on the class path.\n" + "There are currently limits to the size of table\n" + "that can be transmitted to the application in this way -\n" + "it is hoped that this can be improved in a future\n" + "release.\n";
    }

    public TableConsumer createConsumer(Environment env) {
        return this;
    }

    public void consume(StarTable table) throws IOException {
        try {
            try {
                this.remoteDisplay(table);
            }
            catch (ConnectException e) {
                this.startServer();
                this.remoteDisplay(table);
            }
        }
        catch (ServiceException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private void remoteDisplay(StarTable table) throws ConnectException, ServiceException, IOException {
        Object[] tcServ;
        String srcName = table.getName();
        if (srcName == null || srcName.trim().length() == 0) {
            srcName = "(streamed)";
        }
        if ((tcServ = RemoteUtilities.readContactFile((String)"topcat")) == null) {
            throw new ConnectException("No contact file - looks like no TOPCAT server is running");
        }
        String host = (String)tcServ[0];
        int port = (Integer)tcServ[1];
        String cookie = (String)tcServ[2];
        String endpoint = "http://" + host + ":" + port + "/services/TopcatSOAPServices";
        Call call = (Call)new Service().createCall();
        call.setTargetEndpointAddress(endpoint);
        VOTableSerialization.configureCall((Call)call);
        call.setOperationName("displayTable");
        call.addParameter("cookie", XMLType.SOAP_STRING, ParameterMode.IN);
        call.addParameter("table", VOTableSerialization.QNAME_VOTABLE, ParameterMode.IN);
        call.addParameter("location", XMLType.SOAP_STRING, ParameterMode.IN);
        call.setReturnType(XMLType.AXIS_VOID);
        try {
            call.invoke(new Object[]{cookie, table, srcName});
        }
        catch (RemoteException e) {
            Throwable e2 = e.getCause();
            if (e2 instanceof ConnectException) {
                String msg = "Connection refused: TOPCAT server not running?";
                throw (ConnectException)new ConnectException(msg).initCause(e2);
            }
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            throw e;
        }
    }

    private void startServer() throws IOException {
        try {
            Class<?> clazz = Class.forName("uk.ac.starlink.topcat.Driver");
            Method main = clazz.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = TopcatMode.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            main.invoke(null, new Object[]{new String[0]});
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException("TOPCAT not available").initCause(e);
        }
        catch (Exception e) {
            throw (IOException)new IOException("Can't start TOPCAT").initCause(e);
        }
    }

    private static void checkRequisites() {
        (class$uk$ac$starlink$soap$util$RemoteUtilities == null ? (class$uk$ac$starlink$soap$util$RemoteUtilities = TopcatMode.class$("uk.ac.starlink.soap.util.RemoteUtilities")) : class$uk$ac$starlink$soap$util$RemoteUtilities).getName();
        (class$org$apache$axis$encoding$Target == null ? (class$org$apache$axis$encoding$Target = TopcatMode.class$("org.apache.axis.encoding.Target")) : class$org$apache$axis$encoding$Target).getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TopcatMode.checkRequisites();
    }
}

